// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

ODBCThread::ODBCThread(const char *dsn, const char *r, Trunk *trk) :
Service(trk, odbc.getPriority(), odbc.getStack())
{
	dbname = dsn;
	results = r;
}

void ODBCThread::run(void)
{
	ScriptCommand *cmd = trunk->getCommand();
	long err;
	SQLHSTMT hstmt;
	SQLHDBC hdbc;
	SQLCHAR stat[10];
	const char *user = odbc.getLast("user");
	const char *pass = odbc.getLast("password");
	SQLCHAR errmsg[128];
	SQLSMALLINT mlen, col, cols;
	char buf[256];
	const char *query = trunk->getKeyword("query");
	SQLINTEGER rowcnt;
	size_t len = 0;
	const char *opt;
	bool sel = false;
	char nbuf[12];
	unsigned row = 0;
	const char *token = trunk->getKeyword("token");
	const char *mem = trunk->getMember();

	if(!token)
		token = ",";

	if(!user)
		user = "";

	if(!pass)
		pass = "";

	trunk->setSymbol(SYM_SQLROW, "-1");

	cmd->dblock.enterMutex();
	hdbc = (SQLHDBC)cmd->getDatabase();
	if(!hdbc)
	{
		err = SQLAllocHandle(SQL_HANDLE_DBC, odbc.hODBC, &hdbc);
		if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
		{
			cmd->dblock.leaveMutex();
			Service::failure();
		}

		SQLSetConnectAttr(hdbc, SQL_LOGIN_TIMEOUT, (SQLPOINTER *)5, 0);
		err = SQLConnect(hdbc, (SQLCHAR *)dbname, SQL_NTS, (SQLCHAR *)user, SQL_NTS, (SQLCHAR *)pass, SQL_NTS);
		if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
		{
			SQLGetDiagRec(SQL_HANDLE_DBC, hdbc, 1,
                    		stat, &err, errmsg, sizeof(errmsg), &mlen);
			errlog("error", "Database=%s; Error=%s", dbname, errmsg);
			trunk->setSymbol(SYM_SQLERROR, (char *)errmsg);
			SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
			cmd->dblock.leaveMutex();
			Service::failure();
		}
		cmd->setDatabase(hdbc);
		trunk->setConst(SYM_SQLCONNECT, dbname);
		slog.debug("odbc: %s: connected", dbname);
	}
	cmd->dblock.leaveMutex();

	hstmt = (SQLHSTMT)trunk->getPointer(SYM_SQLRESULTS);
	trunk->setPointer(SYM_SQLRESULTS, NULL);

	if(hstmt)
		SQLFreeHandle(SQL_HANDLE_STMT, hstmt);

	err = SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &hstmt);

	if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
	{
		SQLGetDiagRec(SQL_HANDLE_DBC, hdbc, 1,
                   		stat, &err, errmsg, sizeof(errmsg), &mlen);
		errlog("error", "Database=%s; Error=%s", dbname, errmsg);
		trunk->setSymbol(SYM_SQLERROR, (char *)errmsg);
		Service::failure();
	}

	trunk->setPointer(SYM_SQLRESULTS, hstmt);

	if(!mem)
		mem = "";
	if(!query && (!*mem || !stricmp(mem, "detach") || !stricmp(mem, "post")))
	{
		query = buf;
		while(len < sizeof(buf) && NULL != (opt = trunk->getValue(NULL)))
		{
			snprintf(buf + len, sizeof(buf) - len, "%s", opt);
			len = strlen(buf);
		}
	}
	if(!query)
		Service::success();

	while(isspace(*query))
		++query;

	if(!strnicmp(query, "select", 6))
		sel = true;

	err = SQLExecDirect(hstmt, (SQLCHAR *)query, SQL_NTS);
	if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
	{
		SQLGetDiagRec(SQL_HANDLE_DBC, hdbc, 1,
                   		stat, &err, errmsg, sizeof(errmsg), &mlen);
		errlog("error", "Database=%s; Error=%s", dbname, errmsg);
		trunk->setSymbol(SYM_SQLERROR, (char *)errmsg);
		Service::failure();
	}
	SQLRowCount(hstmt, &rowcnt);
	snprintf(buf, sizeof(buf), "%d", rowcnt);
	trunk->setSymbol(SYM_ROWS, buf);
	trunk->setSymbol(SYM_SQLCHANGES, buf);
	if(sel)
		trunk->setSymbol(SYM_SQLROW, "0");
	else
		results = NULL;

	if(!results)
		Service::success();

	for(;;)
	{
		err = SQLFetch(hstmt);
		if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
			break;

		snprintf(nbuf, sizeof(nbuf), "%d", ++row);
		trunk->setSymbol(SYM_SQLROW, nbuf);
		SQLNumResultCols(hstmt, &cols);
		if(cols < 1)
			break;
		col = 0;
		len = 0;
		while(col < cols && len < sizeof(buf) - 1)
		{
			if(len)
				buf[len++] = *token;
			SQLGetData(hstmt, ++col, SQL_C_CHAR, buf + len, (SQLINTEGER)(256 - len), &rowcnt);
			len = strlen(buf);
		}
		trunk->setVariable(results, 0, buf);
	}

	Service::success();
}

#ifdef	CCXX_NAMESPACES
}
#endif
