// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <bayonneserver.h>
#ifdef	HAVE_POSTGRESQL_LIBPQ_FE_H
#include <postgresql/libpq-fe.h>
#else
#ifdef	HAVE_PGSQL_LIBPQ_FE_H
#include <pgsql/libpq-fe.h>
#else
#include <libpq-fe.h>
#endif
#endif

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

class PostgresQueue: public ThreadQueue
{
private:
	friend class PostgresModule;

	static PostgresQueue *first;
	PostgresQueue *next;
	ScriptCommand *cmd;
	const char *dbname, *user, *pass, *query;
	PGconn *conn;
	const char *cdrtable, *cdrlist;

	void startQueue(void);
	void stopQueue(void);
	void runQueue(void *data);
	void cdr(ScriptInterp *interp);

public:
	PostgresQueue(ScriptCommand *cmd);
};

class PostgresThread: public Service
{
private:
	const char *dbname;
	const char *results;

public:
	PostgresThread(const char *dsn, const char *resname, Trunk *trk);
	void run(void);
};


class PostgresModule : protected Trunk::Database
{
private:
	friend class PostgresThread;
	friend class PostgresQueue;
	bool fetch(ScriptInterp *interp, unsigned row);
	bool header(ScriptInterp *interp);
	Service *getService(Trunk *trunk, Line *line, trunkdata_t *data);
	void moduleAttach(ScriptInterp *interp);
	void moduleDetach(ScriptInterp *interp, const char *script);
	int getPriority(void);
	size_t getStack(void);

public:
	PostgresModule();
	~PostgresModule();
};

extern PostgresModule postgres;

#ifdef	CCXX_NAMESPACES
}
#endif
