// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

PostgresQueue *PostgresQueue::first = NULL;

PostgresQueue::PostgresQueue(ScriptCommand *c) :
ThreadQueue(c->getLast("name"), postgres.getPriority(), postgres.getStack())
{
	cmd = c;
	cmd->setThreadQueue(this);
        user = postgres.getLast("user");
        pass = postgres.getLast("password");
	dbname = cmd->getLast("dsn");
	if(!dbname)
		dbname = cmd->getLast("database");

	if(!dbname && cmd == aascript)
		dbname = postgres.getLast("database");

	cdrtable = "calls";

	cdrlist = cmd->getLast("calls");
	if(!cdrlist && cmd == aascript)
		cdrlist = postgres.getLast("calls");
	if(!cdrlist)
	{
		cdrtable = "cdr";
		cdrlist = cmd->getLast("cdr");
	}
	if(!cdrlist && cmd == aascript)
		cdrlist = postgres.getLast("cdr");

	if(!cdrlist)
		cdrtable = NULL;

	next = first;
	first = this;
	conn = NULL;
}

void PostgresQueue::cdr(ScriptInterp *interp)
{
	char sql[256];
	char list[256];
	char varname[65];
	const char *cp;
	bool first = true;
	unsigned len;
	char *tok;

	if(!cdrtable)
		return;

        snprintf(sql, sizeof(sql), "insert into %s values (", cdrtable);
        snprintf(list, sizeof(list), "%s", cdrlist);
        cp = strtok_r(list, ",;: \t\n", &tok);
        while(cp)
        {
                len = strlen(sql);
		if(!strchr(cp, '.'))
		{
			snprintf(varname, sizeof(varname), "session.%s", cp);
			cp = varname;
		}
                cp = interp->getSymbol(cp);
                if(!cp)
                        cp = "";
                if(first)
                        snprintf(sql + len, sizeof(sql) - len - 1, "\'%s\'", cp);
                else
                        snprintf(sql + len, sizeof(sql) - len - 1, ",\'%s\'", cp);
                first = false;
                cp = strtok_r(NULL, ",;: \t\n", &tok);
        }
        len = strlen(sql);
        sql[len++] = ')';
        sql[len++] = 0;
        post(sql, len);
}

void PostgresQueue::startQueue(void)
{
	char buf[256];

	if(pass)
		snprintf(buf, sizeof(buf), "dbname=%s user=%s password=%s",
			dbname, user, pass);
	else if(user)
		snprintf(buf, sizeof(buf), "dbname=%s user=%s",
			dbname, user);
	else
		snprintf(buf, sizeof(buf), "dbname=%s", dbname);

	conn = PQconnectdb(buf);
	if(!conn)
	{
		errlog("failed", "Database=%s, Error=unknown", dbname);
		return;
	}
	if(PQstatus(conn) == CONNECTION_BAD)
	{
		errlog("missing", "Database=%s, Error=%s", dbname, PQerrorMessage(conn));
		PQfinish(conn);
		conn = NULL;
		return;
	}
}

void PostgresQueue::stopQueue(void)
{
	if(!conn)
		return;

	PQfinish(conn);
	conn = NULL;
}

void PostgresQueue::runQueue(void *data)
{
	PGresult *res;
	const char *errmsg;

	query = (const char *)data;
	if(!conn)
		return;

	res = PQexec(conn, query);
        switch(PQresultStatus(res))
        {
        case PGRES_FATAL_ERROR:
                errmsg = PQresultErrorMessage(res);
                errlog("failed", "Database=%s; Error=%s", dbname, errmsg);
                break;
        case PGRES_NONFATAL_ERROR:
        case PGRES_BAD_RESPONSE:
                errmsg = PQresultErrorMessage(res);
                errlog("failed", "Database=%s; Error=%s", dbname, errmsg);
        case PGRES_COMMAND_OK:
        case PGRES_COPY_OUT:
        case PGRES_COPY_IN:
		slog.debug() << "sql: " << dbname << ": " << query << "; modified " << PQcmdTuples(res) << " tuples" << endl;
		break;
	default:
		slog.warn() << "sql: " << dbname << ": " << query << "; query performed as post" << endl;
        }
}

#ifdef	CCXX_NAMESPACES
}
#endif
