// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include <cc++/url.h>
#include <cc++/export.h>
#include <cstdio>
#include <cstdlib>
#include "bayonnescript.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

static class EachProperty : public Script::Property
{
public:
        EachProperty() : Property("each") {};
private:
        void setProperty(char *dp, char *tp, unsigned size);
        void getProperty(char *dp, char *tp, unsigned size)
		{setProperty(tp, dp, size);};
} each;

static class InsertModule : public ScriptModule
{
private:
	char *parseScript(ScriptInterp *interp, Line *line);
	char *checkScript(Line *line, ScriptImage *img);

public:
	InsertModule() : ScriptModule("insert")
		{};
}	diginsert;

static class DeleteModule : public ScriptModule
{
private:
        char *parseScript(ScriptInterp *interp, Line *line);
        char *checkScript(Line *line, ScriptImage *img);

public:
        DeleteModule() : ScriptModule("delete")
                {};
}       digdelete;

static class ReplaceModule : public ScriptModule
{
private:
        char *parseScript(ScriptInterp *interp, Line *line);
        char *checkScript(Line *line, ScriptImage *img);

public:
        ReplaceModule() : ScriptModule("replace")
                {};
}       digreplace;

static class TrimModule : public ScriptModule
{
private:
	char *parseScript(ScriptInterp *interp, Line *line);
	char *checkScript(Line *line, ScriptImage *img);

public:
	TrimModule() : ScriptModule("trim")
		{};
}	digtrim;

static class ChopModule : public ScriptModule
{
private:
        char *parseScript(ScriptInterp *interp, Line *line);
        char *checkScript(Line *line, ScriptImage *img);

public:
        ChopModule() : ScriptModule("chop")
                {};
}       digchop;

static class PrefixModule : public ScriptModule
{
private:
        char *parseScript(ScriptInterp *interp, Line *line);
        char *checkScript(Line *line, ScriptImage *img);

public:
        PrefixModule() : ScriptModule("prefix")
                {};
}       digprefix;

void EachProperty::setProperty(char *dp, char *sp, unsigned size)
{
	while(size > 1 && *sp)
	{
		if(*sp == ',')
		{
			--size;
			++sp;
			continue;
		}
		*(dp++) = *(sp++);
		if(*sp)
			*(dp++) = ',';
		size -= 2;
	}
	*(dp) = 0;
}

char *InsertModule::checkScript(Line *line, ScriptImage *img)
{
	if(!line->argc)
		return "insert arguments missing";

	return NULL;
}

char *DeleteModule::checkScript(Line *line, ScriptImage *img)
{
        if(!line->argc)
                return "delete arguments missing";

        return NULL;
}

char *ReplaceModule::checkScript(Line *line, ScriptImage *img)
{
        if(!line->argc)
                return "replace arguments missing";

        return NULL;
}

char *TrimModule::checkScript(Line *line, ScriptImage *img)
{
	if(!line->argc)
		return "trim arguments missing";

	return NULL;
}

char *ChopModule::checkScript(Line *line, ScriptImage *img)
{
        if(!line->argc)
                return "chop arguments missing";

        return NULL;
}

char *PrefixModule::checkScript(Line *line, ScriptImage *img)
{
        if(!line->argc)
                return "prefix arguments missing";

        return NULL;
}

char *InsertModule::parseScript(ScriptInterp *interp, Line *line)
{
	Symbol *sym;
	unsigned len, l2;
	char *cp, *ep;
	const char *value = interp->getMember();
	int offset = 0;

	if(!value)
		value = interp->getKeyword("offset");

	if(value)
		offset = atoi(value);

	sym = interp->initVariable(interp->getSymbolSize());
	if(!sym)
		return "symbol-not-found";

	if(sym->flags.readonly)
		return "symbol-readonly";

	sym->data[sym->flags.size] = 0;
        len = (unsigned)strlen(sym->data);

        if(offset < 0)
                offset = len + offset;
        if(offset < 0)
                offset = 0;
        if(offset > (int)len)
                offset = len;

        while(len < sym->flags.size && NULL != (value = interp->getValue(NULL)))
        {
                l2 = (unsigned)strlen(value);
                if(len + l2 > sym->flags.size)
                        l2 = sym->flags.size - len;

                cp = sym->data + len;
                ep = cp + l2;
                while(cp > sym->data + offset)
                        *(--ep) = *(--cp);

                memcpy(sym->data + offset, value, l2);
                sym->data[len + l2] = 0;
                offset += l2;
                len += l2;
        }

        sym->flags.initial = false;
        if(sym->flags.commit)
                interp->commit(sym);

	return NULL;
}

char *DeleteModule::parseScript(ScriptInterp *interp, Line *line)
{
	Symbol *sym;
	unsigned len, l2;
	char *cp, *ep;
	const char *value = interp->getMember();
	int offset = 0;

	if(!value)
		value = interp->getKeyword("offset");

	if(value)
		offset = atoi(value);
	else
		value = "0";

	if(!stricmp(value, "end"))
		offset = 255;

	sym = interp->initVariable(interp->getSymbolSize());
	if(!sym)
		return "symbol-not-found";

	if(sym->flags.readonly)
		return "symbol-readonly";

	sym->data[sym->flags.size] = 0;
        len = (unsigned)strlen(sym->data);

        if(offset < 0)
                offset = len + offset;
        if(offset < 0)
                offset = 0;
        if(offset > (int)len)
                offset = -1;

	while(len < sym->flags.size && NULL != (value = interp->getValue(NULL)))
        {
                l2 = (unsigned)strlen(value);

                if(offset < 0)
                {
                        if(l2 > len)
                                continue;

                        if(strnicmp(sym->data + len - l2, value, l2))
                                continue;
                        offset = len - l2;
                }
                else
                {
                        if(strnicmp(sym->data + offset, value, l2))
                                continue;
		}

                cp = sym->data + offset;
                ep = sym->data + offset + l2;
                while(*ep)
                        *(cp++) = *(ep++);
                *cp = 0;
                break;
        }

        sym->flags.initial = false;
        if(sym->flags.commit)
                interp->commit(sym);

	return NULL;
}

char *ReplaceModule::parseScript(ScriptInterp *interp, Line *line)
{
	Symbol *sym;
	unsigned len, l2, l3;
	char *cp, *ep, *rep;
	const char *value = interp->getMember();
	int offset = 0;

	if(!value)
		value = interp->getKeyword("offset");

	if(value)
		offset = atoi(value);
	else
		value = "0";

	if(!stricmp(value, "end"))
		offset = 255;

	sym = interp->initVariable(interp->getSymbolSize());
	if(!sym)
		return "symbol-not-found";

	if(sym->flags.readonly)
		return "symbol-readonly";

	sym->data[sym->flags.size] = 0;
        len = (unsigned)strlen(sym->data);

        if(offset < 0)
                offset = len + offset;
        if(offset < 0)
                offset = 0;
        if(offset > (int)len)
                offset = -1;

	while(len < sym->flags.size && NULL != (value = interp->getValue(NULL)))
        {
                l2 = (unsigned)strlen(value);
                rep = interp->getValue(NULL);
                if(rep)
                        l3 = (unsigned)strlen(rep);
                else
                        l3 = 0;

                if(offset < 0)
                {
                        if(l2 > len)
                                continue;

                        if(strnicmp(sym->data + len - l2, value, l2))
                                continue;
                        offset = len - l2;
                }
                else
                {
                        if(strnicmp(sym->data + offset, value, l2))
                                continue;
                }

                if(l3 > l2)
                {
                        cp = sym->data + len;
                        while((cp--) >= sym->data + offset)
                        {
                                cp[l3 - l2] = *cp;
                        }
                        sym->data[len + l3 - l2] = 0;
                }
                else if(l3 < l2)
                {
                        cp = sym->data + offset + l2 - l3;
                        ep = sym->data + offset;
                        while(*cp)
                                *(ep++) = *(cp++);
                        *ep = 0;
                }
                if(offset + l3 >= len)
                        strcpy(sym->data + offset, rep);
                else
                        memcpy(sym->data + offset, rep, l3);
                break;
        }

        sym->flags.initial = false;
        if(sym->flags.commit)
                interp->commit(sym);

	return NULL;
}

char *TrimModule::parseScript(ScriptInterp *interp, Line *line)
{
	Symbol *sym;
	unsigned len, l2;
	char *cp, *ep;
	const char *value = interp->getMember();
	int offset = 0;

	if(!value)
		value = interp->getKeyword("offset");

	if(value)
		offset = atoi(value);
  	else
   		value = "0";

        if(!stricmp(value, "end"))
                offset = 255;

	sym = interp->initVariable(interp->getSymbolSize());
	if(!sym)
		return "symbol-not-found";

	if(sym->flags.readonly)
		return "symbol-readonly";

	sym->data[sym->flags.size] = 0;
        len = (unsigned)strlen(sym->data);

        if(offset < 0)
                offset = len + offset;
        if(offset < 0)
                offset = 0;
        if(offset > (int)len)
                offset = -1;

        while(len < sym->flags.size && NULL != (value = interp->getValue(NULL)))
        {
                l2 = atoi(value);

                if(offset < 0)
                {
                        if(l2 > len)
                                l2 = len;

                        offset = len - l2;
                }

                cp = sym->data;
                ep = sym->data + offset;
                while(l2-- && *ep)
                        *(cp++) = *(ep++);
                *cp = 0;
                len = (unsigned)strlen(sym->data);
        }

        sym->flags.initial = false;
        if(sym->flags.commit)
                interp->commit(sym);

	return NULL;
}

char *ChopModule::parseScript(ScriptInterp *interp, Line *line)
{
	Symbol *sym;
	unsigned len, l2;
	char *cp, *ep;
	const char *value = interp->getMember();
	int offset = 0;

	if(!value)
		value = interp->getKeyword("offset");

	if(value)
		offset = atoi(value);
  	else
   		value = "0";

        if(!stricmp(value, "end"))
                offset = 255;

	sym = interp->initVariable(interp->getSymbolSize());
	if(!sym)
		return "symbol-not-found";

	if(sym->flags.readonly)
		return "symbol-readonly";

	sym->data[sym->flags.size] = 0;
        len = (unsigned)strlen(sym->data);

        if(offset < 0)
                offset = len + offset;
        if(offset < 0)
                offset = 0;
        if(offset > (int)len)
                offset = -1;

        while(len < sym->flags.size && NULL != (value = interp->getValue(NULL)))
        {
                l2 = atoi(value);

                if(offset < 0)
                {
                        if(l2 > len)
                                l2 = len;

                        offset = len - l2;
                }

                cp = sym->data + offset;
                ep = sym->data + offset + l2;
                while(*ep)
                        *(cp++) = *(ep++);
                *cp = 0;
                len = (unsigned)strlen(sym->data);

        }

        sym->flags.initial = false;
        if(sym->flags.commit)
                interp->commit(sym);

	return NULL;
}

char *PrefixModule::parseScript(ScriptInterp *interp, Line *line)
{
	Symbol *sym;
	unsigned len, l2;
	char *cp, *ep;
	const char *value = interp->getMember();
	unsigned max = 0;

	if(!value)
		value = interp->getKeyword("offset");

	if(value)
		max = atoi(value);

  	sym = interp->initVariable(interp->getSymbolSize());
	if(!sym)
		return "symbol-not-found";

	if(sym->flags.readonly)
		return "symbol-readonly";

	sym->data[sym->flags.size] = 0;
        len = (unsigned)strlen(sym->data);
       	if(!max)
                max = sym->flags.size;

        while(len < sym->flags.size && NULL != (value = interp->getValue(NULL)))
        {
                l2 = (unsigned)strlen(value);
                if(l2 + len > max)
                        continue;

                if(!strnicmp(sym->data, value, l2))
                                continue;

                cp = sym->data + len;
                ep = cp + l2;
                while(cp > sym->data)
                        *(--ep) = *(--cp);

                memcpy(sym->data, value, l2);
                sym->data[len + l2] = 0;
                break;
        }

        sym->flags.initial = false;
        if(sym->flags.commit)
                interp->commit(sym);

	return NULL;
}

#ifdef	CCXX_NAMESPACES
}
#endif



