// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include <cc++/url.h>
#include <cc++/strchar.h>
#include "bayonnescript.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

static class SortModule : public ScriptModule
{
private:
	char *parseScript(ScriptInterp *interp, Line *line);

public:
	SortModule() : ScriptModule("sort")
		{};
        static int forward(const void *x, const void *y)
        {
                char **s1 = (char **)x;
                char **s2 = (char **)y;
                return stricmp(*s1, *s2);
        };

        static int reverse(const void *x, const void *y)
        {
                char **s2 = (char **)x;
                char **s1 = (char **)y;
                return stricmp(*s1, *s2);
        };
}	sortmod;

char *SortModule::parseScript(ScriptInterp *interp, Line *line)
{
	Symbol *sym;
	const char *mem = interp->getMember();
	const char *value = "";
	char *pp, *dp;
	char **idx, *nstr, *sp;
	unsigned size = 0, len = 0, rec = 0;
	unsigned head = 0, tail = 0, pos = 0;
	char packtoken;
	unsigned offset = 0, count = 0, slen;

	if(!mem)
		mem = "forward";

	value = interp->getKeyword("token");
	if(value)
		packtoken = *value;
	else
		packtoken = *interp->getSymbol("script.token");

	if(!size && (NULL != (pp = interp->getKeyword("size"))))
		size = atoi(pp);

	if(!size)
		size = interp->getSymbolSize();

	sym = interp->initVariable(0);
	if(!sym)
		return "symbol-not-found";

	if(sym->flags.readonly && sym->flags.type == Script::NORMAL)
		return "symbol-read-only";

	switch(sym->flags.type)
	{
	case Script::ARRAY:
		sp = sym->data + 5;
		count = sym->data[1];
		rec = sym->data[2] * 256 + sym->data[3] + 1;
		slen = rec * count;
		idx = new char *[count];
		head = 0;
		offset = 0;
		while(head < count)
			idx[offset++] = sp + (rec * (head++));

		head = 0;
		tail = count;
		break;
	case Script::FIFO:
		if(sym->data[1] == sym->data[2])
			return NULL;
		sp = sym->data + 5;
		count = sym->data[4];
		rec = sym->data[3] + 1;
		slen = rec * count;
		idx = new char *[count];
		head = sym->data[1];
		tail = sym->data[2];
		offset = 0;
		while(head != tail)
		{
			idx[offset++] = sp + (rec * head);
			if(++head >= count)
				head = 0;
		}
		head = sym->data[1];
		break;
	case Script::STACK:
		if(stricmp(mem, "reverse"))	// so extract in order
			mem = "reverse";

	case Script::SEQUENCE:
		if(sym->data[2] < 2)
			return NULL;
		sp = sym->data + 5;
		count = sym->data[2];
		rec = sym->data[3] + 1;
		slen = rec * count;
		idx = new char *[count];
		while(offset < count)
		{
			idx[offset] = sp + (rec * offset);
			++offset;
		}
		head = 0;
		tail = count;
		break;
	case Script::NORMAL:
		sp = sym->data;
		slen = sym->flags.size;
		dp = sym->data;
		count = 1;
		while(*dp)
		{
			if(*dp == packtoken)
			++count;
			++dp;
		}
		if(count < 2)
			return NULL;

		idx = new char *[count];
		offset = 0;
		dp = sym->data;
		idx[offset] = dp;
		while(*dp)
		{
			if(*dp == packtoken)
			{
				*(dp++) = 0;
				idx[++offset] = dp;
			}
			else
				++dp;
		}
		++offset;
		break;
	default:
		return "sort-unsupported-type";
	}

	interp->clrTransactions();
	if(!stricmp(mem, "reverse"))
		qsort(idx, offset, sizeof(char *), &reverse);
	else
		qsort(idx, offset, sizeof(char *), &forward);

	nstr = new char[slen];

	switch(sym->flags.type)
	{
	case Script::SEQUENCE:
		sym->data[1] = 0;
	case Script::FIFO:
	case Script::STACK:
	case Script::ARRAY:
		pos = 0;
		len = slen;
		while(pos < offset)
		{
			strcpy(nstr + (rec * head), idx[pos]);
			++pos;
			if(++head >= tail)
				head = 0;
		}
		break;
	case Script::NORMAL:
		offset = len = 0;
		while(offset < count)
		{
			if(offset)
				nstr[len++] = packtoken;	
			strcpy(nstr + len, idx[offset]);
			len += (unsigned)strlen(idx[offset++]);
		}
		break;
	default:
		break;
	}
	memcpy(sp, nstr, len);
	if(sym->flags.commit)
		interp->commit(sym);
	delete[] nstr;
	delete[] idx;
	return NULL;
}

#ifdef	CCXX_NAMESPACES
}
#endif

