// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include <cc++/url.h>
#include <cstdio>
#include <cstdlib>
#include "bayonnescript.h"

#ifndef WIN32
#include <sys/ioctl.h>
# ifdef HAVE_SYS_SOCKIO_H
# include <sys/sockio.h>
# endif
#include <net/if.h>
#else
#include <winsock2.h>
#include <ws2tcpip.h>
#endif

#include "bayonneconfig.h"
#ifdef	HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif

#ifdef	HAVE_SYS_STATVFS_H
#include <sys/statvfs.h>
#define	statfs statvfs
#endif

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

static class IfConfigModule : public ScriptModule
{
private:
	char *parseScript(ScriptInterp *interp, Line *line);

public:
	IfConfigModule() : ScriptModule("ifconfig") {};
}	sys_ifconfig;

#if defined(HAVE_SYS_VFS_H)

static class DiskfreeModule : public ScriptModule
{
private:
	char *parseScript(ScriptInterp *interp, Line *line);

public:
	DiskfreeModule() : ScriptModule("diskspace") {};
}	sys_df;

char *DiskfreeModule::parseScript(ScriptInterp *interp, Line *line)
{
	const char *mem = interp->getMember();
	const char *path = interp->getKeyword("path");
	const char *save = interp->getKeyword("save");
	long total, used;
	char buf[13];
	char devname[65];


	if(!save)
		save = interp->getKeyword("var");

	if(!path)
	{
		path = interp->getKeyword("drive");
		if(path && *path != '/')
		{
			snprintf(devname, sizeof(devname), "/dev/%s", path);
			path = devname;
		}
	}

	if(!path)
		path = interp->getValue(NULL);

	if(!path)
		path = "/var";
		

	if(!mem)
		mem = "free";

	if(!save)
		return "no-save";

	if(*save == '&')
		++save;

	interp->setVariable(save, 3, "-");

#ifdef	HAVE_SYS_VFS_H

	struct statfs fs;

	if(statfs(path, &fs))
		return "disk-invalid-path";

        used = fs.f_blocks - fs.f_bfree;
        total = fs.f_blocks / 100l;

	if(!stricmp(mem, "used"))
		sprintf(buf, "%ld", used / total);
	else
		sprintf(buf, "%ld", fs.f_bavail / total);

	interp->setVariable(save, 3, buf);	

#endif


	return NULL;
}

#endif

char *IfConfigModule::parseScript(ScriptInterp *interp, Line *line)
{
	const char *ifaddr = interp->getKeyword("address");
	const char *ifmask = interp->getKeyword("netmask");
	const char *ifmtu = interp->getKeyword("mtu");
	const char *ifname = interp->getKeyword("interface");
        char buffer[8192];
	char buf[24];
        struct ifconf ifc;
        int fd = socket(AF_INET, SOCK_DGRAM, 0);
        unsigned count;
        unsigned idx = 0;
        struct ifreq devifreq;
        char *cp;
        struct sockaddr_in *addr;

	if(ifaddr && *ifaddr == '&')
		++ifaddr;

	if(ifmask && *ifmask == '&')
		++ifmask;

	if(ifmtu && *ifmtu == '&')
		++ifmtu;

	if(ifaddr)
		interp->setVariable(ifaddr, 16, "0.0.0.0");

	if(ifmask)
		interp->setVariable(ifmask, 16, "255.255.255.255");

	if(ifmtu)
		interp->setVariable(ifmtu, 5, "0");

	if(fd < 0)
		return "cannot-access";

	if(!ifname)
		ifname = interp->getValue(NULL);

	if(!ifname)
	{
		close(fd);
		return "no-interface-specified";
	}

        ifc.ifc_len = sizeof(buffer);
        ifc.ifc_buf = buffer;

        if(ioctl(fd, SIOCGIFCONF, &ifc) < 0)
                exit(-1);

        count = ifc.ifc_len / sizeof(struct ifreq);

        while(idx < count)
        {
                if(!strcasecmp(ifc.ifc_req[idx].ifr_name, ifname))
                        break;
                ++idx;
        }

	if(idx >= count)
	{
		close(fd);
		return "no-interface-found";
	}
        addr = (struct sockaddr_in *)&ifc.ifc_req[idx].ifr_addr;
	if(ifaddr)
		interp->setVariable(ifaddr, 16, inet_ntoa(addr->sin_addr));
        strcpy(devifreq.ifr_name, ifc.ifc_req[idx].ifr_name);

        if(ifmask && ioctl(fd, SIOCGIFNETMASK, &devifreq) != -1)
        {
                addr = (struct sockaddr_in *)&devifreq.ifr_addr;
		interp->setVariable(ifmask, 16, inet_ntoa(addr->sin_addr));
        }

#ifndef	SIOCGLIFMTU
        if(ifmtu && ioctl(fd, SIOCGIFMTU, &devifreq) != -1)
	{
		sprintf(buf, "%d", devifreq.ifr_mtu);
		interp->setVariable(ifmtu, 5, buf);
	}
#endif

	close(fd);
	return NULL;
}

#ifdef	CCXX_NAMESPACES
}
#endif



