// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
//
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include <cc++/config.h>
#include <ctime>
#include "bayonnescript.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

static class TimeProperty : public Script::Property
{
public:
	TimeProperty() : Property("time") {};
	TimeProperty(const char *id) : Property(id) {};

private:
	virtual void setProperty(char *dp, char *tp, unsigned size);
	virtual void getProperty(char *dp, char *tp, unsigned size);
	virtual void setValue(char *dp, unsigned size, long value);
	virtual long getValue(const char *dp);
	virtual bool isProperty(const char *dp);
	virtual long adjustValue(long);

	unsigned getPropertySize(void)
		{return 8;};
} pTime;

void TimeProperty::setValue(char *dp, unsigned size, long value)
{
	unsigned hr, min, sec;

	hr = value / 3600;
	value %= 3600;

	min = value / 60;
	value %= 60;
	sec = value;

	if(size >= 8)
		snprintf(dp, 9, "%02d:%02d:%02d", hr, min, sec);
	else if(size > 5)
		snprintf(dp, 6, "%02d:%02d", hr, min);
	else
		snprintf(dp, size + 1, "%d", 3600 * hr + 60 * min + sec);	
}

bool TimeProperty::isProperty(const char *dp)
{
	if(strchr(dp, ':'))
		return true;

	return false;
}

long TimeProperty::adjustValue(long value)
{
	const long day = 24 * 3600;
	value %= day;
	if(value < 0)
		value = day + value;
	return value;
}

long TimeProperty::getValue(const char *dp)
{
	unsigned hr = 0, min = 0, sec = 0;
	const char *ext;

	ext = strchr(dp, ':');
	if(ext)
	{
		hr = atoi(dp);
		min = atoi(++ext);
		ext = strchr(ext, ':');
	}
	else
		sec = atoi(dp);
	if(ext)
		sec = atoi(++ext);

	return adjustValue(hr * 3600 + min * 60 + sec);	
}

void TimeProperty::getProperty(char *dp, char *tp, unsigned size)
{
	unsigned hr, min = 0, sec = 0;
	char *ext;

	hr = atoi(dp);
	ext = strchr(dp, ':');
	if(ext)
	{
		min = atoi(++ext);
		ext = strchr(ext, ':');
	}
	if(ext)
		sec = atoi(++ext);

	hr %= 24;
	min %= 60;
	sec %= 60;

	if(size < 4)
		return;
	if(size < 6)
		sprintf(tp, "%02d%02d", hr, min);
	else
		sprintf(tp, "%02d%02d%02d", hr, min, sec);
	return;
}

void TimeProperty::setProperty(char *dp, char *tp, unsigned size)
{
	time_t now;
	struct tm *dt;
	unsigned sz = 8;
	unsigned hr = 0, min = 0, sec = 0;
	
	if(size < 8)
		sz = size;

	strncpy(dp, "00:00:00", sz);
	if(size < 5)
		return;

	sz = (unsigned)strlen(tp);
	if(!sz)
	{
		::time(&now);
		dt = ::localtime(&now);
		if(size < 8)
			sprintf(dp, "%02d:%02d", dt->tm_hour, dt->tm_min);
		else
			sprintf(dp, "%02d:%02d:%02d", dt->tm_hour, dt->tm_min, dt->tm_sec);
		return;
	}
	if(strchr(tp, ':'))
		sscanf(tp, "%02u:%02u:%02u", &hr, &min, &sec);
	else
		sscanf(tp, "%02u%02u%02u", &hr, &min, &sec);
	hr %= 24;
	min %= 60;
	sec %= 60;
 	snprintf(dp, size + 1, "%02u:%02u:%02u", hr, min, sec);
}

#ifdef	CCXX_NAMESPACES
}
#endif

