/*
** Copyright (C) 1999-2000 Open Source Telecom Corporation.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "bts.h"

static int netcount = 0;

static char *strupper(char *cp)
{
	char *rp = cp;
	while(*cp)
	{
		if(strchr("\t,;:|\r\n", *cp))
			*cp = ' ';
		else
			*cp = toupper(*cp);
		++cp;
	}
	return rp;
}

static void setEnv(char *id, char *data)
{
	char buffer[256];
	char *ep;
	unsigned len;

	if(!data)
		return;

	while(isspace(*data) || *data == '=')
		++data;

	ep = strchr(data, '\n');
	if(ep)
		*ep = 0;
	ep = strchr(data, '\r');
	if(ep)
		*ep = 0;
	if(!strcmp(id, "CONFIG_KEYDATA"))
		snprintf(buffer, sizeof(buffer), "%s=%s/", id, data);
	else
		snprintf(buffer, sizeof(buffer), "%s=%s", id, data);
	len = strlen(buffer);
	ep = (char *)malloc(++len);
	strcpy(ep, buffer);
	putenv(ep);
}

static int check(void)
{
	char buffer[512];
	FILE *fp;
	int pid;

	putenv("BAYONNE_STATUS=dead");
	putenv("BAYONNE_DRIVERS=");
	putenv("BAYONNE_PID=");

	snprintf(buffer, sizeof(buffer), "%s.pid", getenv("BAYONNE_CONTROL"));
	fp = fopen(buffer, "r");
	if(!fp)
		return 0;

	fgets(buffer, sizeof(buffer), fp);
	fclose(fp);
        pid = atoi(buffer);
        if(!pid)
                return 0;
        if(kill(pid, 0))
		return 0;

	snprintf(buffer, sizeof(buffer), "%d", pid);
	setEnv("BAYONNE_PID", buffer);
	putenv("BAYONNE_STATUS=live");
	return 1;
}
	

static void sysconfig(void)
{
	static char keypath[256];
	char buffer[256];
	FILE *fp;
	char *cp;

	snprintf(keypath, sizeof(keypath), "CONFIG_KEYDATA=%s/", PATH_KEYCONFDIR);
	putenv(keypath);
	putenv("PROXY_SERVER=");
	putenv("PROXY_PORT=");
	putenv("BAYONNE_LANGUAGE=english");
	putenv("BAYONNE_VOICE=UsEngM");
	putenv("BAYONNE_DIALPLAN=1");
	putenv("BAYONNE_BTSVERSION=1");
	putenv("USAGE_PHYSICAL_COUNT=0");
	putenv("USAGE_VIRTUAL_COUNT=0");
	putenv("USAGE_NETWORK_COUNT=0");
	putenv("USAGE_SPECIAL_COUNT=0");
        putenv("USAGE_PHYSICAL_USED=100");
        putenv("USAGE_VIRTUAL_USED=100");
        putenv("USAGE_NETWORK_USED=100");
        putenv("USAGE_SPECIAL_USED=100");
        putenv("USAGE_PHYSICAL_AVAIL=0");
        putenv("USAGE_VIRTUAL_AVAIL=0");
        putenv("USAGE_NETWORK_AVAIL=0");
        putenv("USAGE_SPECIAL_AVAIL=0");
        putenv("USAGE_PHYSICAL_PEAK=0");
        putenv("USAGE_VIRTUAL_PEAK=0");
        putenv("USAGE_NETWORK_PEAK=0");
        putenv("USAGE_SPECIAL_PEAK=0");


	fp = fopen(PATH_SYSCONFIG, "r");
	if(!fp)
		return;

	for(;;)
	{
		fgets(buffer, sizeof(buffer), fp);
		if(feof(fp))
			break;
		cp = buffer;
		while(isspace(*cp))
			++cp;
		if(!strncmp(cp, "VOICE", 5))
			setEnv("BAYONNE_VOICE", cp + 5);
		else if(!strncmp(cp, "DIALPLAN", 8))
			setEnv("BAYONNE_DIALPLAN", cp + 8);
		else if(!strncmp(cp, "LANGUAGE", 8))
			setEnv("BAYONNE_LANGUAGE", cp + 8);
		else if(!strncmp(cp, "CONFIG", 6))
			setEnv("CONFIG_KEYDATA", cp + 6);
		else if(!strncmp(cp, "PROXY_SERVER", 12))
			setEnv("PROXY_SERVER", cp + 12);
		else if(!strncmp(cp, "PROXY_PORT", 10))
			setEnv("PROXY_PORT", cp + 10);     
	}
	fclose(fp);
}

void setServer(void)
{
	char *cp;
	char buffer[256];
	keydata_t *server;
	
	putenv("BAYONNE_TOKEN=&");
	putenv("BAYONNE_USER=bayonne");
	putenv("BAYONNE_GROUP=bayonne");
	putenv("BAYONNE_NODE=localhost");
	server = getkeydata("/server/server");

	if(!server)
		return;

	setEnv("BAYONNE_TOKEN", getkeylast(server, "token"));
	setEnv("BAYONNE_USER", getkeylast(server, "user"));
	setEnv("BAYONNE_GROUP", getkeylast(server, "group"));
	setEnv("BAYONNE_NODE", getkeylast(server, "node"));
	setEnv("BAYONNE_DIALPLAN", getkeylast(server, "dialplan"));
	endkeydata(server);
}

void setPaths(void)
{
	char *cp;
	char buffer[256];
	keydata_t *paths;
	char *libpath = PATH_LIBDIR_BAYONNE;

	putenv("PATH_TMP=/tmp");	
	putenv("PATH_TMPFS=/dev/tmpfs");
	putenv("BAYONNE_LIBRARY=" PATH_LIBDIR_BAYONNE);
	putenv("BAYONNE_BINPATH="  PATH_BINDIR_BAYONNE);
	putenv("PATH_LIBEXEC=" PATH_DATADIR_LIBEXEC);
	putenv("PATH_SCRIPTS=" PATH_DATADIR_SCRIPTS);
	putenv("PATH_VOICES=" PATH_DATADIR_VOICES);
	putenv("PATH_PROMPTS=" PATH_DATADIR_PROMPTS);
	putenv("PATH_INCLUDES=" PATH_DATADIR_INCLUDES);
	putenv("PATH_DATAFILES=" PATH_VARLIB_BAYONNE);
	putenv("PATH_RUNFILES=" PATH_VARRUN_BAYONNE);
	putenv("PATH_CACHE=" PATH_VARCACHE_BAYONNE);
	putenv("PATH_SPOOL=" PATH_VARSPOOL_BAYONNE);
	putenv("PATH_LOGS=" PATH_VARLOG_BAYONNE);
		
	paths = getkeydata("/server/paths");

	if(!paths)
		return;

	cp = getkeylast(paths, "libpath");
	if(cp)
	{
		libpath = cp;
		setEnv("BAYONNE_LIBRARY", cp);
	}

	setEnv("PATH_TMP", getkeylast(paths, "tmp"));
	setEnv("PATH_TMPFS", getkeylast(paths, "tmpfs"));
	setEnv("BAYONNE_BINDIR", getkeylast(paths, "binpath"));
	setEnv("PATH_LIBEXEC", getkeylast(paths, "libexec"));
	setEnv("PATH_SCRIPTS", getkeylast(paths, "scripts"));
	setEnv("PATH_PROMPTS", getkeylast(paths, "prompts"));
	setEnv("PATH_VOICES", getkeylast(paths, "voices"));
	setEnv("PATH_INCLUDES", getkeylast(paths, "includes"));
	setEnv("PATH_DATAFILES", getkeylast(paths, "datafiles"));
	setEnv("PATH_RUNFILES", getkeylast(paths, "runfiles"));
	setEnv("PATH_CACHE", getkeylast(paths, "cache"));
	setEnv("PATH_SPOOL", getkeylast(paths, "spool"));
	setEnv("PATH_LOGS", getkeylast(paths, "logpath"));

	snprintf(buffer, sizeof(buffer), "%s/perl5", libpath);
	setEnv("PERL5LIB", buffer);
	snprintf(buffer, sizeof(buffer), "%s/python", libpath);
	setEnv("PYTHONPATH", buffer);
	endkeydata(paths);
}

static void setInstalled(void)
{
	keydata_t *installed = getkeydata("/server/installed");
	char *dlist, *dn;
	char name[65];
		
	putenv("INSTALLED_DRIVERS=");
	putenv("INSTALLED_DATABASES=");
	putenv("INSTALLED_OPTIONS=");

	if(!installed)
		return;

	setEnv("INSTALLED_DRIVERS", strupper(getkeylast(installed, "drivers")));
	setEnv("INSTALLED_DATABASES", strupper(getkeylast(installed, "databases")));
	setEnv("INSTALLED_OPTIONS", strupper(getkeylast(installed, "options")));
	dlist = getkeylast(installed, "drivers");
	if(!dlist)
		return;

	dn = strtok(dlist, " ,;:|\t\r\n");
	while(dn)
	{
		snprintf(name, sizeof(name), "DRIVER_%s_COUNT", dn);
		setEnv(name, "0");
		snprintf(name, sizeof(name), "DRIVER_%s_USED", dn);
		setEnv(name, "0");
		dn = strtok(NULL, " ,;:|\t\r\n");
	}
}

static void getPolicy(void)
{
	char buffer[512];
	char *cp, *pn;
	int count, in, out, pin, pout;
	char name[65], value[32];
	FILE *fp;
	char plist[256];
	unsigned len = 0;

	snprintf(buffer, sizeof(buffer), "%s.stats", getenv("BAYONNE_CONTROL"));
	fp = fopen(buffer, "r");
	if(!fp)
		return;

	for(;;)
	{
		fgets(buffer, sizeof(buffer), fp);
		if(feof(fp))
			break;
		pn = strtok(buffer, " ");
		if(!strcmp(pn, "*"))
			pn = "default";

		count = atoi(strtok(NULL, " "));
		in = atoi(strtok(NULL, " "));
		out = atoi(strtok(NULL, " "));
		pin = atoi(strtok(NULL, " "));
		pout = atoi(strtok(NULL, " "));

		if(len)
			snprintf(plist + len, sizeof(plist) - len, " %s", pn);
		else
			snprintf(plist, sizeof(plist), "%s", pn);
		len = strlen(plist);

		snprintf(name, sizeof(name), "POLICY_%s_COUNT", pn);
		snprintf(value, sizeof(value), "%d", count);
		setEnv(name, value);
		
		if(!count)
		{
			snprintf(name, sizeof(name), "POLICY_%s_USED", pn);
			setEnv(name, "100");
			snprintf(name, sizeof(name), "POLICY_%s_AVAIL", pn);
			setEnv(name, "0");
			snprintf(name, sizeof(name), "POLICY_%s_PEAK", pn);
			setEnv(name, "0");
			continue;
		}
                snprintf(name, sizeof(name), "POLICY_%s_COUNT", pn);
                snprintf(value, sizeof(value), "%d", count);
                setEnv(name, value);

                snprintf(name, sizeof(name), "POLICY_%s_USED", pn);
                snprintf(value, sizeof(value), "%d",((in + out) * 100) / count);
                setEnv(name, value);

                snprintf(name, sizeof(name), "POLICY_%s_AVAIL", pn);
                snprintf(value, sizeof(value), "%d", count - in - out);
                setEnv(name, value);

                snprintf(name, sizeof(name), "POLICY_%s_PEAK", pn);
                snprintf(value, sizeof(value), "%d", pin + pout);
                setEnv(name, value);
	}
	setEnv("BAYONNE_POLICIES", plist);
	fclose(fp);
	endkeydata(NULL);
}
	
static void getUsage(void)
{
	char buffer[512];
	char l1[82], l2[82], l3[82], l4[82];
	char value[32];
	char *cp;
	int count, in, out, pin, pout;
	char *names[4] = {"PHYSICAL", "VIRTUAL", "NETWORK", "SPECIAL"};
	char name[65];
	char *lines[4] = {l1, l2, l3, l4};
	char *line;
	int i;
	FILE *fp;

	snprintf(buffer, sizeof(buffer), "%s.usage", getenv("BAYONNE_CONTROL"));
	fp = fopen(buffer, "r");
	if(!fp)
		return;

	fgets(l1, sizeof(l1), fp);
	fgets(l2, sizeof(l2), fp);
	fgets(l3, sizeof(l3), fp);
	fgets(l4, sizeof(l4), fp);
	fclose(fp);

	for(i = 0; i < 4; ++i)
	{
		cp = strtok(lines[i], " ");
		cp = strtok(NULL, " ");
		count = atoi(strtok(NULL, " "));
		in = atoi(strtok(NULL, " "));
		out = atoi(strtok(NULL, " "));
		pin = atoi(strtok(NULL, " "));
		pout = atoi(strtok(NULL, " "));
		if(i == 2)
			count = netcount;
		snprintf(name, sizeof(name), "USAGE_%s_COUNT", names[i]);
		snprintf(value, sizeof(value), "%d", count);
		setEnv(name, value);
		if(!count)
			continue;

                snprintf(name, sizeof(name), "USAGE_%s_USED", names[i]);
                snprintf(value, sizeof(value), "%d", 
			((in + out) * 100) / count);
		setEnv(name, value);

                snprintf(name, sizeof(name), "USAGE_%s_AVAIL", names[i]);
                snprintf(value, sizeof(value), "%d", count - in - out);
		setEnv(name, value);

                snprintf(name, sizeof(name), "USAGE_%s_PEAK", names[i]);
                snprintf(value, sizeof(value), "%d", pin + pout);
                setEnv(name, value);
	}
}

static void getDrivers(void)
{
	char dvlist[128];
	char buffer[512];
	char name[65];
	char value[32];
	unsigned len = 0;
	char *cp, *dn;
	FILE *fp;

	snprintf(buffer, sizeof(buffer), "%s.drivers", getenv("BAYONNE_CONTROL"));
	fp = fopen(buffer, "r");
	if(!fp)
		return;

	for(;;)
	{
		fgets(buffer, sizeof(buffer), fp);
		if(feof(fp))
			break;

		if(!isalpha(buffer[0]))
			continue;

		dn = strupper(strtok(buffer, " \t\r\n"));
		if(len)
			snprintf(dvlist + len, sizeof(dvlist) - len, " %s", dn);
		else
			snprintf(dvlist, sizeof(dvlist), "%s", dn);
		len = strlen(dvlist);
		cp = strtok(NULL, " \t\r\n");
		snprintf(name, sizeof(name), "DRIVER_%s_COUNT", dn);
		snprintf(value, sizeof(value), "%d", atoi(cp));
		if(!strcmp(dn, "OH323") || !strcmp(dn, "SIP"))
			netcount += atoi(cp);
		setEnv(name, value);
                cp = strtok(NULL, " \t\r\n");
                snprintf(name, sizeof(name), "DRIVER_%s_USED", dn);
                snprintf(value, sizeof(value), "%d", atoi(cp));
                setEnv(name, value);
	}
	fclose(fp);
	setEnv("BAYONNE_DRIVERS", dvlist);
}


int main(int argc, char **argv)
{
	static char home[512];
	static char path[512];
	static char ctrl[512];
	struct passwd *pwd;
	struct group *grp;
	char *cp = strrchr(argv[0], '/');

	if(cp)
		++cp;
	else
		cp = argv[0];

	if(argc != 2)
	{
		fprintf(stderr, "use: %s shell-script\n", cp);
		exit(-1);
	}

	if(!strcmp(cp, "bts-root") && getuid())
	{
		fprintf(stderr, "bts-root: must execute under root\n");
		exit(-1);
	}

	sysconfig();
	setPaths();
	setServer();
	setInstalled();

	grp = getgrnam(getenv("BAYONNE_USER"));
	pwd = getpwnam(getenv("BAYONNE_GROUP"));

	if(grp)
	{
		setgid(grp->gr_gid);
		umask(0002);
	}

	if(pwd && strcmp(cp, "bts-root") && !getuid())
	{
		if(!setuid(pwd->pw_uid))
		{
			snprintf(home, sizeof(home), "HOME=%s", pwd->pw_dir);
			putenv(home);
			setEnv("LOGNAME", pwd->pw_name);
			setEnv("USER", pwd->pw_name);
		}
	}

	endpwent();
	endgrent();

	chdir(getenv("PATH_DATAFILES"));
	setEnv("BAYONNE_VERSION", VERSION);

	if(!access(getenv("PATH_RUNFILES"), R_OK))
		snprintf(ctrl, sizeof(ctrl), "BAYONNE_CONTROL=%s/bayonne", getenv("PATH_RUNFILES"));
	else
		snprintf(ctrl, sizeof(ctrl), "BAYONNE_CONTROL=%s/.bayonne/", getenv("HOME"));		
	putenv(ctrl);

	if(check())
	{
		getDrivers();
		getUsage();
		getPolicy();
	}

	snprintf(path, sizeof(path), "PATH=%s:%s:%s", PATH_BTSLIBDIR, getenv("BAYONNE_BINPATH"), getenv("PATH"));
	putenv(path);
	execvp("/bin/sh", argv);
	exit(-1);
}
