/*
** Copyright (C) 1999-2000 Open Source Telecom Corporation.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <pwd.h>
#include <grp.h>
#include "bayonneconfig.h"
#include "bayonnepaths.h"

#ifndef	KEY_PAGESIZE
#define	KEY_PAGESIZE 512
#endif

typedef struct _mempage
{
	struct _mempage *next;
	size_t used;
	char page[KEY_PAGESIZE - sizeof(struct _mempage *) - sizeof(size_t)];
} keydata_t;

typedef struct
{
	char *sym;
	char *value;
} keyinit_t;

keydata_t *newkeydata(void);
keydata_t *getkeydata(const char *keypath);
keydata_t *addkeydata(keydata_t *keys, const char *keypath);
char *getkeyfirst(keydata_t *keys, const char *sym);
char *getkeylast(keydata_t *keys, const char *sym);
char **getkeylist(keydata_t *keys, const char *sym);
keydata_t *initkeydata(const char *keypath, keyinit_t *list);
void setkeyvalue(keydata_t *keys, const char *sym, char *data);
void clrkeyvalue(keydata_t *keys, const char *sym);
int getkeycount(keydata_t *keys, const char *sym);
void endkeydata(keydata_t *keys);
int getkeyindex(keydata_t *keys, char **data, int max);

