/*
** Copyright (C) 1999-2000 Open Source Telecom Corporation.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "bts.h"

static int optcmd(char *s1, char *s2)
{ 
        while(*s1 == '-')
                ++s1;

        while(*s2 == '-')
                ++s2;

        return strcmp(s1, s2);
}

static char *strupper(char *cp)
{
	char *rp = cp;
	while(*cp)
	{
		if(strchr("\t,;:|\r\n", *cp))
			*cp = ' ';
		else
			*cp = toupper(*cp);
		++cp;
	}
	return rp;
}

static void setEnv(char *id, char *data)
{
	char buffer[256];
	char *ep;
	unsigned len;

	if(!data)
		return;

	while(isspace(*data) || *data == '=')
		++data;

	ep = strchr(data, '\n');
	if(ep)
		*ep = 0;
	ep = strchr(data, '\r');
	if(ep)
		*ep = 0;
	if(!strcmp(id, "CONFIG_KEYDATA"))
		snprintf(buffer, sizeof(buffer), "%s=%s/", id, data);
	else
		snprintf(buffer, sizeof(buffer), "%s=%s", id, data);
	len = strlen(buffer);
	ep = (char *)malloc(++len);
	strcpy(ep, buffer);
	putenv(ep);
}

static void sysconfig(void)
{
        static char keypath[256];
        char buffer[256];
        FILE *fp;
        char *cp;

        snprintf(keypath, sizeof(keypath), "CONFIG_KEYDATA=%s/", PATH_KEYCONFDIR);
        putenv(keypath);
	putenv("BAYONNE_LANGUAGE=english");
        putenv("BAYONNE_VOICE=UsEngM");

	fp = fopen(PATH_SYSCONFIG, "r");
        if(!fp) 
                return;

	for(;;)
        {
                fgets(buffer, sizeof(buffer), fp);
                if(feof(fp))
                        break;
                cp = buffer;
                while(isspace(*cp))
                        ++cp;
                if(!strncmp(cp, "VOICE", 5))
                        setEnv("BAYONNE_VOICE", cp + 5);
                else if(!strncmp(cp, "LANGUAGE", 8))
                        setEnv("BAYONNE_LANGUAGE", cp + 8);
                else if(!strncmp(cp, "CONFIG", 6))
                        setEnv("CONFIG_KEYDATA", cp + 6);
	}
	fclose(fp);
}

void setPaths(void)
{
	char *cp;
	char buffer[256];
	keydata_t *paths;
	char *libpath = PATH_LIBDIR_BAYONNE;

	putenv("PATH_TMP=/tmp");	
	putenv("PATH_TMPFS=/dev/tmpfs");
	putenv("BAYONNE_LIBRARY=" PATH_LIBDIR_BAYONNE);
	putenv("BAYONNE_BINPATH="  PATH_BINDIR_BAYONNE);
	putenv("PATH_LIBEXEC=" PATH_DATADIR_LIBEXEC);
	putenv("PATH_SCRIPTS=" PATH_DATADIR_SCRIPTS);
	putenv("PATH_VOICES=" PATH_DATADIR_VOICES);
	putenv("PATH_PROMPTS=" PATH_DATADIR_PROMPTS);
	putenv("PATH_INCLUDES=" PATH_DATADIR_INCLUDES);
	putenv("PATH_DATAFILES=" PATH_VARLIB_BAYONNE);
	putenv("PATH_RUNFILES=" PATH_VARRUN_BAYONNE);
	putenv("PATH_CACHE=" PATH_VARCACHE_BAYONNE);
	putenv("PATH_SPOOL=" PATH_VARSPOOL_BAYONNE);
	putenv("PATH_LOGS=" PATH_VARLOG_BAYONNE);
		
	paths = getkeydata("/server/paths");

	if(!paths)
		return;

	cp = getkeylast(paths, "libpath");
	if(cp)
	{
		libpath = cp;
		setEnv("BAYONNE_LIBRARY", cp);
	}

	setEnv("PATH_TMP", getkeylast(paths, "tmp"));
	setEnv("PATH_TMPFS", getkeylast(paths, "tmpfs"));
	setEnv("BAYONNE_BINDIR", getkeylast(paths, "binpath"));
	setEnv("PATH_LIBEXEC", getkeylast(paths, "libexec"));
	setEnv("PATH_SCRIPTS", getkeylast(paths, "scripts"));
	setEnv("PATH_PROMPTS", getkeylast(paths, "prompts"));
	setEnv("PATH_VOICES", getkeylast(paths, "voices"));
	setEnv("PATH_INCLUDES", getkeylast(paths, "includes"));
	setEnv("PATH_DATAFILES", getkeylast(paths, "datafiles"));
	setEnv("PATH_RUNFILES", getkeylast(paths, "runfiles"));
	setEnv("PATH_CACHE", getkeylast(paths, "cache"));
	setEnv("PATH_SPOOL", getkeylast(paths, "spool"));
	setEnv("PATH_LOGS", getkeylast(paths, "logpath"));
}

void setServer(void)
{
        char *cp;
        char buffer[256];
        keydata_t *server;

	putenv("BAYONNE_NODE=localhost");
        putenv("BAYONNE_USER=bayonne");
        putenv("BAYONNE_GROUP=bayonne");
        server = getkeydata("/server/server");

	if(!server)
                return;

        setEnv("BAYONNE_USER", getkeylast(server, "user"));
        setEnv("BAYONNE_GROUP", getkeylast(server, "group"));
        setEnv("BAYONNE_NODE", getkeylast(server, "node"));
        endkeydata(server);
}

static char *getPath(char *path)
{
	char buffer[512];
	char *ret;
	char *ext;

	buffer[0] = 0;
	if(strchr(path, ':'))
	{
		if(!strncmp(path, "cache:", 6))
			snprintf(buffer, sizeof(buffer), "%s/%s", getenv("PATH_CACHE"), path + 6);
		else if(!strncmp(path, "spool:", 6))
			snprintf(buffer, sizeof(buffer), "%s/%s", getenv("PATH_SPOOL"), path + 6);
		else if(!strncmp(path, "tmp:", 4))
			snprintf(buffer, sizeof(buffer), "%s/.bayonne/%s", getenv("PATH_TMP"), path + 4);
		else if(!strncmp(path, "temp:", 5)) 
			snprintf(buffer, sizeof(buffer), "%s/.bayonne/%s", getenv("PATH_TMP"), path + 5);
		else if(!strncmp(path, "mem:", 4) || !strncmp(path, "ram:", 4))
			snprintf(buffer, sizeof(buffer), "%s/.bayonne/%s", getenv("TMP_TMPFS"), path + 4);
		else if(!strncmp(path, "prompts:", 8))
			snprintf(buffer, sizeof(buffer), "%s/%s", getenv("PATH_PROMPTS"), path + 8);
		else
		{
			snprintf(buffer, sizeof(buffer), "%s/%s", getenv("PATH_VOICES"), path);
			ret = strchr(buffer, ':');
			*ret = '/';
		}
	}
	else if(strchr(path, '/'))
		snprintf(buffer, sizeof(buffer), "%s/%s", getenv("PATH_DATAFILES"), path);
	else
		snprintf(buffer, sizeof(buffer), "%s/%s/%s",getenv("PATH_VOICES"), getenv("BAYONNE_VOICE"), path);

	ext = strrchr(buffer, '/');
	if(ext)
		ext = strrchr(buffer, '.');
	if(!ext)
		snprintf(buffer + strlen(buffer), sizeof(buffer) - strlen(buffer), getenv("BAYONNE_EXTENSION"));

	ret = (char *)malloc(strlen(buffer) + 1);
	strcpy(ret, buffer);
	return ret;
}

static void echo(int argc, char **argv)
{
	while(--argc)
		printf("%s\n", getPath(*(++argv)));
	exit(0);
}

static void erase(int argc, char **argv)
{
	while(--argc)
		remove(getPath(*(++argv)));
	exit(0);
}

int main(int argc, char **argv)
{
	static char home[512];
	static char path[512];
	static char ctrl[512];
	char *cp = strrchr(argv[0], '/');
	char *voice = getenv("VOICE");
	char *ext = getenv("EXTENSION");

	if(!ext)
		ext = ".au";

	struct passwd *pwd;
	struct group *grp;

	if(cp)
		++cp;
	else
		cp = argv[0];

	sysconfig();
	setServer();
	setPaths();

	grp = getgrnam(getenv("BAYONNE_USER"));
	pwd = getpwnam(getenv("BAYONNE_GROUP"));

	if(grp)
	{
		setgid(grp->gr_gid);
		umask(0002);
	}

	if(pwd && !getuid())
	{
		if(!setuid(pwd->pw_uid))
		{
			snprintf(home, sizeof(home), "HOME=%s", pwd->pw_dir);
			putenv(home);
			setEnv("LOGNAME", pwd->pw_name);
			setEnv("USER", pwd->pw_name);
		}
	}

	endpwent();
	endgrent();

	if(voice)
		setEnv("BAYONNE_VOICE", voice);

	setEnv("BAYONNE_EXTENSION", ext);

	if(!strcmp("erase", cp))
		erase(argc, argv);
	else if(!strcmp("paths", cp))
		echo(argc, argv);

	if(argc < 2)
	{
		fprintf(stderr, "use: [VOICE=lib] btspaths --command ...\n");
		exit(-1);
	}

	++argv;
	--argc;
	if(!optcmd(argv[0], "--erase"))
		erase(argc, argv);
	else if(!optcmd(argv[0], "--echo"))
		echo(argc, argv);
	fprintf(stderr, "btspaths: unrecognized options\n");
	exit(-1);
}
