// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with the Festival Light text to speech synthesis system known as
// "flite" and available from the Language Technologies Institute of
// Carnegie Mellon Univerity to produce a executable image so long as each
// source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license alone or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

extern "C" {

#include <flite.h>
cst_voice *register_cmu_us_kal();

};

#include "bayonneserver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

class Flite : public TTS
{
private:
	cst_voice *v;
	bool synth(unsigned id, trunkdata_t *data);

public:
	const char *getName(void)
		{return "flite";};

	Flite();
	~Flite();

} flite;

Flite::Flite() : TTS()
{
	flite_init();
	v = register_cmu_us_kal();	
	slog.debug() << "TTS: installing flite synth" << endl;
}

Flite::~Flite()
{
}

bool Flite::synth(unsigned id, trunkdata_t *data)
{
	char path[96];

	switch(data->play.mode)
	{
	case PLAY_MODE_TEXT:
	case PLAY_MODE_FILE:
		break;
	default:
		return true;
	}

	if(data->play.cache)
	{
		if(!strnicmp(data->play.cache, "cache/", 6))
		{
			data->play.lock = true;
			cachelock.readLock();
		}

		sprintf(path, "%s.wav", data->play.cache);
		if(canAccess(path))
		{
			strcpy(data->play.list, path);
			data->play.name = data->play.list;		
			data->play.extension = ".wav";
			data->play.timeout = 0;
			data->play.repeat = 0;
			data->play.maxtime = 0;
			data->play.mode = PLAY_MODE_ONE;
			return true;
		}
		if(data->play.lock)
		{
			cachelock.unlock();
			cachelock.writeLock();
		}
	}
	else
	{	
		sprintf(path, "temp/flite-%04d.wav", id);
		remove(path);
	}

	switch(data->play.mode)
	{
	case PLAY_MODE_TEXT:
		flite_text_to_speech(data->play.list, v, path);
		break;
	case PLAY_MODE_FILE:
		if(!canAccess(data->play.list))
		{
			return false;
		}
		flite_file_to_speech(data->play.list, v, path);
	default:
		return true;
	}
	strcpy(data->play.list, path);
	if(data->play.cache)
		data->play.mode = PLAY_MODE_ONE;
	else
		data->play.mode = PLAY_MODE_TEMP;
	data->play.name = data->play.list;
	data->play.extension = ".wav";
	data->play.timeout = 0;
	data->play.repeat = 0;
	data->play.maxtime = 0;
	return true;
}

#ifdef	CCXX_NAMESPACES
}
#endif

