// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonnelibrary.h"
#include <cstdlib>
#include <climits>

#if defined(HAVE_SYS_PARAM_H)
#include <sys/param.h>
#endif

#ifndef	PATH_MAX
#define	PATH_MAX	MAXPATHLEN
#endif

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

#ifdef	HAVE_REALPATH

bool permitAudioAccess(const char *path, bool write)
{
	char *cp, *ext;

	char source[PATH_MAX];
	char target[PATH_MAX];
	const char *var = keypaths.getDatafiles();
	unsigned lvar;

	ext = strrchr(path, '.');
	if(!ext)
		return false;

	if(stricmp(ext, ".au") &&
	   stricmp(ext, ".wav") &&
	   stricmp(ext, ".al") &&
	   stricmp(ext, ".ul") &&
	   stricmp(ext, ".snd") &&
	   stricmp(ext, ".raw") &&
	   stricmp(ext, ".vox") &&
	   stricmp(ext, ".gsm"))
		return false;

	if(!write)
		return true;

	snprintf(source, sizeof(source), "%s", path);
	cp = strrchr(source, '/');
	if(!cp)
		return false;

	*cp = 0;

	if(!realpath(source, target))
		return false;

	if(!isDir(target))
		return false;

	cp = strrchr(target + 1, '/');
	if(!cp)
		return false;

	if(!stricmp(cp, "/.bayonne"))
		return true;

	if(!stricmp(cp, "/bayonne"))
		return true;

	if(cp[1] == '.')
		return false;

	if(!strnicmp(PATH_LOCALSTATE_BAYONNE "/", target, 5))
		return true;

	realpath(var, source);
	var = source;
	lvar = strlen(var);

	if(!strnicmp(var, target, lvar))
	{
		if(target[lvar] != '/')
			return false;

		++lvar;
		if(target[lvar] == '.')
			return false;

		return true;
	}

	return false;
}

bool permitFileAccess(const char *path)
{
	char *cp;

	char source[PATH_MAX];
	char target[PATH_MAX];
	const char *var = keypaths.getDatafiles();
	unsigned lvar;

	snprintf(source, sizeof(source), "%s", path);
	cp = strrchr(source, '/');
	if(!cp)
		return false;

	*cp = 0;
	if(!realpath(source, target))
		return false;

	if(!isDir(target))
		return false;

	cp = strrchr(target, '/');
	if(!cp)
		return false;

	++cp;

	if(!stricmp(cp, ".bayonne"))
		return true;

	realpath(var, source);
	var = source;
	lvar = strlen(var);

	if(!strnicmp(var, target, lvar))
	{
		if(target[lvar] != '/')
			return false;
		++lvar;
		if(target[lvar] == '.')
			return false;

		return true;
	}
	else
		return false;
}

#else

bool permitFileAccess(const char *path)
{
	if(strstr(path, ".."))
		return false;

	if(*path == '/')
	{
		if(strstr(path, "/.bayonne/"))
			return true;
		return false;
	}

	if(*path == '.')
		return false;

	return true;
}

bool permitAudioAccess(const char *path, bool write)
{
	const char *var = keypaths.getDatafiles();
	const char *ext = strrchr(path, '.');
	if(!ext)
		return false;

	if(stricmp(ext, ".au") &&
	   stricmp(ext, ".wav") &&
	   stricmp(ext, ".al") &&
	   stricmp(ext, ".ul") &&
	   stricmp(ext, ".snd") &&
	   stricmp(ext, ".raw") &&
	   stricmp(ext, ".vox") &&
	   stricmp(ext, ".gsm"))
		return false;

	if(strstr(path, ".."))
		return false;

	if(*path == '.')
		return false;

	if(!write)
		return true;

	if(!strnicmp(path, "/var/", 5))
		return true;

	if(!strnicmp(path, var, strlen(var)))
		return true;

	if(!strstr(path, "/.bayonne/"))
		return true;

	return false;
}

#endif


AudioBuffer::AudioBuffer()
{
	size = 4096;
	buf = new char[size];
	start = len = 0;
}

AudioBuffer::~AudioBuffer()
{
	delete[] buf;
}

void AudioBuffer::getBuffer(char *data, unsigned amount)
{
	int left, copied;

	if(amount == 0)
	{
		return;
	}

	enterMutex();
	if(len == 0)
	{
		memset(data, 0, amount);
		leaveMutex();
		return;
	}

	if(amount > len)
		memset(data + len, 0, amount - len);

	left = ((amount) < (len) ? amount : len);
	if((start + left) > size)
	{
		copied = size - start;
		memcpy(data, buf + start, copied);
		data += copied;
		left -= copied;
		len -= copied;
		start = 0;
	}

	if(left > 0)
	{
		memcpy(data, buf + start, left);
		len -= left;
		start = (start + left) % size;
	}
	leaveMutex();
}

void AudioBuffer::putBuffer(const char *data, unsigned amount)
{
	int nl, written, removed, offset;

	if(amount == 0)
		return;

	enterMutex();
	nl = len + amount;
	if(len > size)
	{
		removed = nl - size;
		start = (start + removed) % size;
		len -= removed;
	}

	offset = (start + len) % size;
	if((offset + amount) > size)
	{
		written = size - offset;
		memcpy(buf + offset, data, written);
		offset = 0;
		data += written;
		amount -= written;
		len += written;
	}

	if(amount > 0)
	{
		memcpy(buf + offset, data, amount);
		len += amount;
	}
	leaveMutex();
}

#ifdef	CCXX_NAMESPACES
}
#endif



