// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifdef  __FreeBSD__
#define getopt(a, b, c) getopt()
#include <unistd.h>
#undef getopt
#endif

#include <cc++/config.h>
#include <cc++/process.h>
#include <cc++/url.h>
#ifdef  linux
#include <sys/vfs.h>
#endif
#include <sys/wait.h>
#include <sys/utsname.h>
#include <netinet/tcp.h>
#include <sys/un.h>
#include <getopt.h>
#include <cerrno>
#include "bayonneserver.h"
#include <iomanip>

#ifdef  CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

KeyPaths::KeyPaths() :
Keydata("/server/paths")
{
#ifdef  WIN32

        static Keydata::Define defpaths[] = {
        {"var", PATH_LOCALSTATE_BAYONNE},
        {"tmp", PATH_VARTMP_BAYONNE},
        {"tmpfs", PATH_VARTMP_BAYONNE},
        {"spool", PATH_VARSPOOL_BAYONNE},
        {"cache", PATH_VARCACHE_BAYONNE},
        {"runfiles", PATH_VARRUN_BAYONNE},
        {"logpath", PATH_VARLOG_BAYONNE},
        {"datafiles", PATH_VARLIB_BAYONNE},
        {"scripts", PATH_DATADIR_SCRIPTS},
        {"voices", PATH_DATADIR_VOICES},
        {"prompts", PATH_DATADIR_PROMPTS},
        {"libexec", PATH_DATADIR_LIBEXEC},
        {"includes", PATH_DATADIR_INCLUDES},
        {NULL, NULL}};

#else
        static Keydata::Define defpaths[] = {
        {"var", PATH_LOCALSTATE_BAYONNE},
        {"tmp", PATH_VARTMP_BAYONNE},
        {"tmpfs", PATH_VARTMP_BAYONNE},
        {"spool", PATH_VARSPOOL_BAYONNE},
        {"cache", PATH_VARCACHE_BAYONNE},
        {"runfiles", PATH_VARRUN_BAYONNE},
        {"logpath", PATH_VARLOG_BAYONNE},
        {"sox", "/usr/bin/sox"},
        {"datafiles", PATH_VARLIB_BAYONNE},
        {"scripts", PATH_DATADIR_SCRIPTS},
        {"voices", PATH_DATADIR_VOICES},
        {"prompts", PATH_DATADIR_PROMPTS},
        {"libexec", PATH_DATADIR_LIBEXEC},
        {"includes", PATH_DATADIR_INCLUDES},
        {NULL, NULL}};
#endif

        load(defpaths);
}

static statnode_t node;

static int optcmp(const char *s1, const char *s2)
{
	if(!strnicmp(s1, "--active", 8))
		s1 += 8;
	if(!strnicmp(s2, "--active", 8))
		s2 += 8;
	while(*s1 == '-')
		++s1;
	while(*s2 == '-')
		++s2;
	return stricmp(s1, s2);
}

static bool check(const char *runfiles)
{
#ifdef	WIN32
	return true;
#else
	FILE *fp;
	int pid;
	char buffer[256];

	snprintf(buffer, sizeof(buffer), "%s/bayonne.pid", runfiles);
	fp = fopen(buffer, "r");
	if(!fp)
	{
		snprintf(buffer, sizeof(buffer), "%s/.bayonne.pid", Process::getEnv("HOME"));
		fp = fopen(buffer, "r");
	}
	if(!fp)
		return false;
	fgets(buffer, sizeof(buffer), fp);
	pid = atoi(buffer);
	if(!pid)
		return false;
	if(kill(pid, 0))
		return false;
	return true;
#endif
}

static void uptime(void)
{
	exit(0);
}

static void status(const char *runfiles)
{
	InetAddress addr;
	time_t now, live;
	char buffer[256];
#ifdef	WIN32
	HANDLE fd;
#else
	int fd;
#endif

	if(!check(runfiles))
	{
		cerr << "offline" << endl;
		exit(-1);
	}

	snprintf(buffer, sizeof(buffer), "%s/bayonne.nodes", runfiles);
	if(!canModify(buffer))
		snprintf(buffer, sizeof(buffer), "%s/.bayonne.nodes", Process::getEnv("HOME"));

#ifdef	WIN32
	fd = CreateFile(name, GENERIC_READ | GENERIC_WRITE, 0,
		NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL));
#else
	fd = ::open(buffer, O_RDONLY);
#endif
	if(fd < 0)
	{
		cerr << "btsinfo: cannot access status" << endl;
		exit(-1);
	}
	cout << setiosflags(ios::left);
        cout << setw(20) << "name" << setw(0) << " ";
        cout << setw(20) << "address" << setw(0);
        cout << setw(5) << "live" << setw(0);
        cout << setw(0) << "status" << endl << endl;

	time(&now);
	for(;;)
	{
#ifdef	WIN32
		DWORD ioc;
		ReadFile(fd, &node, sizeof(node), &ioc, NULL));
		if(ioc < sizeof(node))
			break;
#else
                if(::read(fd, &node, sizeof(node)) < sizeof(node))
                        break;
#endif
                if(!node.name[0])
                        continue;

                addr = node.addr;
                live = now - node.update;
                if(live < 0)
                        live = 0;
                if(live > 9999)
                        live = -1;

                cout << setiosflags(ios::left);
                cout << setw(20) << node.name << setw(0) << " ";
                cout << setw(20) << addr << setw(0);
                if(live > -1)
                        cout << setw(5) << live << setw(0);
                else
                        cout << "---- ";
                cout << setw(0) << node.stat << endl;
        }
        exit(0);
}

extern "C" int main(int argc, char **argv)
{
	char keydata[128];
	const char *cp = Process::getEnv("CONFIG_KEYDATA");

#ifdef	WIN32
	char *p;

	snprintf(keydata, sizeof(keydata), "%s", argv[0]);
	p = strrchr(keydata, '\\');
	if(p)
	{
		*p = 0;
		p = strchr(keydata, '\\');
		if(p)
			strcpy(p, "\\Config\\");
	}
	else
	{
		p = strrchr(keydata, '/');
		if(p)
		{
			*p = 0;
			p = strrchr(keydata, '/');
		}
		if(p)
			strcpy(p, "/Config/");
	}
	if(!p)
	{
		p = strrchr(keydata. ':');
		if(p)
			strcpy(p, "Config/");
	}
	if(!p)
		snprintf(keydata, sizeof(keydata), "%s", "../Config/");
	 
#else
	if(!cp || !*cp)
		snprintf(keydata, sizeof(keydata), "%s/", PATH_KEYCONFDIR);
#endif
	if(!cp || !*cp)
		Process::setEnv("CONFIG_KEYDATA", keydata, true);

	KeyPaths paths;

	if(argc != 2)
	{
		cerr << "btsinfo: unkown or missing option" << endl;
		exit(-1);
	}
	if(!optcmp(argv[1], "--uptime"))
		uptime();
	else if(!optcmp(argv[1], "--status"))
		status(paths.getRunfiles());
	else if(!optcmp(argv[1], "--active-scripts"))
		cout << paths.getLast("scripts") << endl;
	else if(!optcmp(argv[1], "--active-prompts") || !stricmp(argv[1], "--prompts"))
		cout << paths.getLast("prompts") << endl;
	else if(!optcmp(argv[1], "--active-voices"))
		cout << paths.getLast("voices") << endl;
	else if(!optcmp(argv[1], "--active-libexec"))
		cout << paths.getLast("libexec") << endl;
	else if(!optcmp(argv[1], "--help"))
	{
		cerr << "use: btsinfo [option]" << endl;
		cerr << "--libexec   report libexec directory" << endl;
                cerr << "--prompts   report prompt directory" << endl;
		cerr << "--scripts   report script directory" << endl;
		cerr << "--voices    report voice directory" << endl;
		cerr << "--status    report node status" << endl;
		cerr << "--uptime    report server uptime" << endl;
	}
	else
	{
		cerr << "btsinfo: " << argv[1] << ": invalid info request " << endl;
		exit(-1);
	}
	exit(0);
}

#ifdef  COMMON_OST_NAMESPACE
};
#endif


