// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include "bayonneserver.h"
#include <cc++/process.h>
#include <process.h>
#include <cstdio>
#include <iostream>
#include <fstream>
#include <sys/stat.h>

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

static bool test = true;

static BOOL WINAPI stop(DWORD code)
{
	Driver *drv = Driver::drvFirst;

	if(!test && code == CTRL_LOGOFF_EVENT)
		return TRUE;

	if(code)
			errlog("failed", "Bayonne exiting; reason=%d", code);
	else
			errlog("notice", "Bayonne exiting; normal termination");

	if(debug)
		debug->debugFinal(code);

	stopServers();

	while(drv)
	{
		drv->stop();
		drv = drv->drvNext;
	}
	running = false;
	exit(code);
	return TRUE;
}

// setup core environment at start with absolute paths since
// we may later do a chdir that will kill the relative paths
// passed initially from bayonne.bat.  This also creates
// runtime directories.

static void start(const char *route)
{
	ScriptSymbol *globals = Trunk::getGlobals();
	Driver *drv = Driver::drvFirst;
	unsigned ports = 0;
	char pbuf[256];
	char path[128];
	char env[256];
	const char *cp = getenv("BAYONNE_LIBRARY");
	const char *p = getenv("PATH");
	const char *tmp = getenv("TMP");
	SYSTEM_INFO sysinfo;
	OSVERSIONINFO osver;
	const char *cpu = "x86";
	char nodename[MAX_COMPUTERNAME_LENGTH + 1];
	DWORD namelen = MAX_COMPUTERNAME_LENGTH + 1;
	TrunkGroup *policy;
	char *tok, *pp;
	size_t plen = 0;
	unsigned total = 0;

	if(cp && *cp)
	{
		test = false;
		chdir(cp);
		getcwd(path, sizeof(path));
		snprintf(env, sizeof(env), "BAYONNE_LIBRARY=%s", path);
		putenv(env);
		snprintf(env, sizeof(env), "CONFIG_KEYDATA=%s\\Config", path);
		putenv(env);
		snprintf(env, sizeof(env), "PATH=%s\\bin;%s", path, p);
		chdir("bin");
		if(route)
			keyserver.setValue("default", route);
	}
	else
	{
		plugins.setValue("debug", "trace");
		keypaths.setValue("datafiles", "../var");
		if(route)
			keyserver.setValue("testing", route);
	}

	cp = getenv("CONFIG_KEYDATA");
	keypaths.setValue("etc", cp);

	if(tmp)
	{
		snprintf(path, sizeof(path), "%s\\bayonne", tmp);
		keypaths.setValue("tmp", path);
	}

	cp = getenv("BAYONNE_DRIVER");
	if(cp && *cp)
			plugins.setValue("drivers", cp);


	Dir::create(keypaths.getLast("datafiles"));
	chdir(keypaths.getLast("datafiles"));
	Dir::create(keypaths.getLast("var"));
	Dir::create(keypaths.getLast("cache"));
	Dir::create(keypaths.getLast("tmp"));
	Dir::create(keypaths.getLast("spool"));
	Dir::create(keypaths.getLast("logpath"));
	Dir::create(keypaths.getLast("runfiles"));
	cp = keypaths.getLast("runfiles");
	snprintf(path, sizeof(path), "%s/drivers.map", cp);
	keypaths.setValue("drvmap", path);
	snprintf(path, sizeof(path), "%s/nodes.map", cp);
	keypaths.setValue("nodes", path);
	snprintf(path, sizeof(path), "%s/calls.map", cp);
	keypaths.setValue("calls", path);
	snprintf(path, sizeof(path), "%s/usage.map", cp);
	keypaths.setValue("usage", path);
	snprintf(path, sizeof(path), "%s/stats.map", cp);
	keypaths.setValue("stats", path);
	snprintf(path, sizeof(path), "%s/server.ctl", cp);
	keypaths.setValue("control", path);	
	snprintf(path, sizeof(path), "%s/routes.map", cp);
	keypaths.setValue("routes", path);
        snprintf(path, sizeof(path), "%s/routes.tmp", cp);
        keypaths.setValue("tmproutes", path);

	Process::setEnv("SERVER_SHELL", keypaths.getLast("shell"), true);
	Process::setEnv("SERVER_PLATFORM", plugins.getLast("drivers"), true);
	Process::setEnv("SERVER_LIBEXEC", keypaths.getLibexec(), true);
	Process::setEnv("SERVER_SOFTWARE", "bayonne", true);
	Process::setEnv("SERVER_PROTOCOL", "3.0", true);
	Process::setEnv("SERVER_VERSION", "W32", true);
	Process::setEnv("SERVER_TOKEN", keyserver.getToken(), true);

	osver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osver);
	GetComputerName(nodename, &namelen);
	keyserver.setValue("node", nodename);
	GetSystemInfo(&sysinfo);
	switch(sysinfo.wProcessorArchitecture)
	{
	case PROCESSOR_ARCHITECTURE_INTEL:
		switch(sysinfo.wProcessorLevel)
		{
		case 3:
			cpu = "i386";
			break;
		case 4:
			cpu = "i486";
			break;
		case 5:
			cpu = "i586";
			break;
		}
		break;
	case PROCESSOR_ARCHITECTURE_PPC:
		cpu = "ppc";
		break;
	case PROCESSOR_ARCHITECTURE_MIPS:
		cpu = "mips";
		break;
	case PROCESSOR_ARCHITECTURE_ALPHA:
		cpu = "alpha";
		break;
	}

	snprintf(path, sizeof(path), "%s/server.log", keypaths.getLast("logpath"));
	remove(path);
	slog.open(path);

	if(test)
		slog.level(Slog::levelDebug);
	else
		slog.level(Slog::levelNotice);

	snprintf(env, sizeof(env), " W32 %d.%02d", osver.dwMajorVersion, osver.dwMinorVersion);
    slog.info() << "SERVER VERSION " << "2.0 ; " << nodename << " " << cpu << env << endl;
    slog.info() << "TGI VERSION 3.0";
    slog() << "; driver(s)=" << plugins.getLast("drivers");
    slog() << "; etc=" << keypaths.getLast("etc") << endl;

	slog.debug() << "Loading DSO plugin images..." << endl;
	plugins.loadDebug();
	plugins.loadDriver();
	plugins.loadDatabase();
	plugins.loadExtensions();
	plugins.loadModules();
	plugins.loadCodecs();
	plugins.loadTranslators();
	keyserver.loadGroups(test);

	initScripting();
	ScriptModule::init();

	drv = Driver::drvFirst;
	while(drv)
	{
		slog.debug() << "Starting " << drv->getName() << " driver..." << endl;
		ports += drv->start();
		drv = drv->drvNext;
	}

	if(ports)
		slog.info("driver started for %d port(s)", ports);
	else
	{
		slog.critical() << "no trunk ports activated" << endl;
		stop(-1);
	}

	startServers();

	if(keyserver.getLast("config"))
		slog.notice() << "normal startup; " << keyserver.getLast("config") << endl;
	else
		slog.notice() << "normal startup" << endl;

	policy = TrunkGroup::getGroup(NULL);

	if(policy->getLast("groups"))
		setString(env, sizeof(env), policy->getLast("groups"));
	else
		setString(env, sizeof(env), "*");

	pbuf[0] = 0;
	pp = strtok_r(env, " ,;\t\n", &tok);
	while(pp && plen < sizeof(pbuf))
	{
		if(plen)
			pbuf[plen++] = ',';
		setString(pbuf + plen, sizeof(pbuf) - plen, pp);
		plen = strlen(pbuf);
		pp = strtok_r(NULL, " ,;\t\n", &tok);
	}

	globals->setConst(SYM_POLICIES, pbuf);

	drv = Driver::drvFirst;
	while(drv)
	{
		total += drv->getTrunkCount();
		drv = drv->drvNext;
	}
	snprintf(env, sizeof(env), "%d", total);
	globals->setConst(SYM_PORTS, env);
	globals->setConst(SYM_SERVER, "bayonne");
	globals->setConst(SYM_VERSION, "w32");
	globals->setConst(SYM_NODE, keyserver.getNode());
	globals->setConst(SYM_SCRIPTS, keypaths.getScriptFiles());
	globals->setConst(SYM_PROMPTS, keypaths.getPromptFiles());
	globals->setConst(SYM_RELEASE, "2");
	globals->setSymbol(SYM_SERVICE, 64);

	if(test)
			globals->setSymbol(SYM_SERVICE, "test");
	else
			globals->setSymbol(SYM_SERVICE, "up");

	globals->setSymbol(SYM_SCHEDULE, 64);
	globals->setSymbol(SYM_SCHEDULE, "none");

	new KeyTones();
	Driver::setNodes();
	keyserver.printRoutes();

	running = true;
}

static void init(void)
{
	FILE *fp;
	char buffer[1024];
	char *p;

	snprintf(buffer, sizeof(buffer), "%s/startup.ini", keypaths.getLast("etc"));
	fp = fopen(buffer, "r");
	if(!fp)
		return;

	for(;;)
	{
		fgets(buffer, sizeof(buffer), fp);
		if(feof(fp))
			break;
		if(!buffer[0])
			continue;
		p = buffer + strlen(buffer) - 1;
		while(isspace(*p))
		{
			*(p--) = 0;
			if(p < buffer)
				break;
		}
		p = buffer;
		while(*p && isspace(*p))
			++p;

		if(!*p)
			continue;
		if(!isalpha(*p))
			continue;

		fifo.command(p);
	}
	fclose(fp);
}

static void check(void)
{
	Dir dir(keypaths.getCache());
	const char *entry;
	char path[128];
	time_t now;
	struct stat ino;

	slog.debug() << "server: checking cache..." << endl;

	time(&now);
	while(NULL != (entry = dir.getName()))
    {
		if(*entry == '.')
			continue;

		snprintf(path, sizeof(path), "cache/%s", entry);
        if(::stat(path, &ino))
			continue;

		if(now - ino.st_mtime >= 3600)
        {
			cachelock.writeLock();
            remove(path);
            cachelock.unlock();
        }
	}
}

static HANDLE hPacket;

#define	BUFSIZE 1024
#define	PIPE_TIMEOUT 10000

typedef struct
{
		OVERLAPPED o;
		HANDLE hPipe;
		CHAR buffer[BUFSIZE];
		DWORD toWrite;
} PACKET, *LPPACKET;

static void endPacket(LPPACKET lpp)
{
	DisconnectNamedPipe(lpp->hPipe);
	CloseHandle(lpp->hPipe);
	GlobalFree(lpp);
}

static bool getPacket(LPOVERLAPPED lpo)
{
	bool pending = false;

	hPacket = CreateNamedPipe("\\\\.\\pipe\\bayonne",
		PIPE_ACCESS_DUPLEX | FILE_FLAG_OVERLAPPED,
		PIPE_TYPE_MESSAGE | PIPE_READMODE_MESSAGE | PIPE_WAIT,
		PIPE_UNLIMITED_INSTANCES,
		BUFSIZE, BUFSIZE, PIPE_TIMEOUT, NULL);

	if(hPacket == INVALID_HANDLE_VALUE)
		return false;

	ConnectNamedPipe(hPacket, lpo);
	switch(GetLastError())
	{
	case ERROR_IO_PENDING:
		pending = true;
		break;
	case ERROR_PIPE_CONNECTED:
		SetEvent(lpo->hEvent);
		break;
	}
	return pending;
}

static VOID WINAPI getRead(DWORD dwErr, DWORD cbBytes, LPOVERLAPPED lpo);
static VOID WINAPI getWrite(DWORD dwErr, DWORD cbBytes, LPOVERLAPPED lpo);

static VOID WINAPI getRead(DWORD dwErr, DWORD cbBytes, LPOVERLAPPED lpo)
{
	Trunk *trunk;
	LPPACKET lpp = (LPPACKET)lpo;	
	BOOL flag = FALSE;
	const char *p = lpp->buffer + 2;
	const char *cp;

	if((dwErr == 0) && (cbBytes > 0))
	{
		while(isspace(*p))
			++p;
		lpp->buffer[1] = '-';
		trunk = fifo.command(p);
		lpp->toWrite = 2;
		if(lpp->buffer[0])
		{
			lpp->buffer[2] = 0;
			if(trunk)
				lpp->buffer[1] = '1';
			else
				lpp->buffer[1] = '0';
			cp = NULL;
			if(trunk && trunk != ((Trunk *)(-1)))
				cp = trunk->getTrunkGid();
			if(cp)
				cp = strchr(cp, '-');
			if(cp && lpp->buffer[1] =='1')
			{
				lpp->buffer[1] = 'S';
				snprintf(lpp->buffer + 2, 64, "session.trunkid=%s", cp);
				lpp->toWrite = (DWORD)(2 + strlen(lpp->buffer + 2));
			}
		}

		flag = WriteFileEx(lpp->hPipe, lpp->buffer, lpp->toWrite, lpo, getWrite);
	}
	if(!flag)
		endPacket(lpp);
}

static VOID WINAPI getWrite(DWORD dwErr, DWORD cbBytes, LPOVERLAPPED lpo)
{
	LPPACKET lpp = (LPPACKET)lpo;
	BOOL flag = FALSE;

	if((dwErr == 0) && (cbBytes == lpp->toWrite))
		flag = ReadFileEx(lpp->hPipe, lpp->buffer, BUFSIZE, lpo, getRead);
	if(!flag)
		endPacket(lpp);
}

#ifdef	CCXX_NAMESPACES
};
#endif

using namespace std;
using namespace ost;

void main(int argc, char **argv)
{
	ost::Driver *drv;
	HANDLE hConnect, hNodes = INVALID_HANDLE_VALUE;
	OVERLAPPED over;
	LPPACKET lpp;
	DWORD dwWait, cbBytes;
	bool pending;
	const char *cp;
	TimerPort timer;
	timeout_t step;
	unsigned seccount = 0;
	unsigned mincount = 0;
	int statinterval = atoi(keyserver.getLast("stats"));

	if(argc != 2)
	{
		cerr << "bayonne.exe: must be started from bayonne.bat" << endl;
		exit(-1);
	}
	if(!stricmp(argv[1], "-start"))
		start(NULL);
	else if(!stricmp(argv[1], "-config"))
	{
		start(NULL);
		cp = getenv("BAYONNE_LIBRARY");
		if(!cp)
				cp = "-test-";

		cout << "LIBRARY=" << cp << endl;
		cout << "CONFIG=" << getenv("CONFIG_KEYDATA") << endl;
		exit(0);
	}
	else
		start(argv[1]);

	hConnect = CreateEvent(NULL, TRUE, TRUE, NULL);
	if(!hConnect)
	{
		slog.critical() << "server: no control event handle" << endl;
		stop(-1);
	}

	over.hEvent = hConnect;
	pending = getPacket(&over);

	errlog("notice", "Bayonne/w32 running");
	SetConsoleTitle("Bayonne");
	SetConsoleCtrlHandler((PHANDLER_ROUTINE)stop, TRUE);
	init();
    timer.setTimer(1000);

	for(;;)
	{
		step = timer.getTimer();
		if(!step)
		{
			timer.setTimer(1000);
			drv = ost::Driver::drvFirst;
			while(drv)
			{
					drv->secTick();
					drv = drv->drvNext;
			}
			if(!(seccount % 10) && hNodes != INVALID_HANDLE_VALUE)
			{
				// FIXME: logic for writing nodes file...
			}
//			if(!(seccount % statinterval))
//				stats.scan();

			if(++seccount >= 60)
			{
				if(usage)
					usage->report();
				TrunkGroup::logStats();
				Session::clean();
				Sync::check();
				seccount = 0;
				if(++mincount >= 10)
				{
					check();
					mincount = 0;
				}
			}
			continue;
		}
		if(hPacket == INVALID_HANDLE_VALUE)
		{
			Thread::sleep(step);
			dwWait = WAIT_TIMEOUT;
		}
		else
			dwWait = WaitForSingleObjectEx(hConnect, step, TRUE);

		switch(dwWait)
		{
		case 0:
			if(pending)
				GetOverlappedResult(hPacket, &over, &cbBytes, FALSE);
			lpp = (LPPACKET) GlobalAlloc(GPTR, sizeof(PACKET));
			lpp->hPipe = hPacket;
			lpp->toWrite = 0;
			getWrite(0, 0, (LPOVERLAPPED) lpp);
			pending = getPacket(&over);
			break;
		case WAIT_TIMEOUT:
			break;
		}
	}
	stop(0);
}
