// Copyright (C) 1999-2002 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of Common C++.
// 
// The exception is that, if you link the Common C++ library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the Common C++ library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name Common C++.  If you copy code from other releases into a copy of
// Common C++, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for Common C++, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include <cc++/config.h>
#include <cc++/export.h>
#include <cc++/file.h>
#include "private.h"

#ifdef WIN32
#include <malloc.h>
#endif

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

Dir::Dir(const char *fname) :
#ifdef WIN32
hDir(INVALID_HANDLE_VALUE), name(NULL)
#else
dir(NULL)
#endif
{
#ifdef HAVE_READDIR_R
       save = reinterpret_cast<struct dirent*>(save_space);
#endif
	if(fname)
		open(fname);
}

bool Dir::create(const char *path, Attr attr)
{
	long xmask = 0;
	bool rtn = true;
#ifdef	WIN32

	// fixme: make it form a security attributes structure

	if(!CreateDirectory(path, NULL))
		rtn = false;
#else
	switch(attr)
	{
	case attrPublic:
		xmask |= S_IXOTH;
	case attrGroup:
		xmask |= S_IXGRP;
	case attrPrivate:
		xmask |= S_IXUSR;
		break;
	default:
		return false;
	}
	if(mkdir(path, (long)attr | xmask))
		rtn = false;
#endif
	return rtn;
}

bool Dir::remove(const char *path)
{
	bool rtn = true;
#ifdef	WIN32
	if(!RemoveDirectory(path))
		rtn = false;
#else
	if(rmdir(path))
		rtn = false;
#endif
	return rtn;
}

bool Dir::setPrefix(const char *prefix)
{
	bool rtn = true;

#ifdef	WIN32
	if(!SetCurrentDirectory(prefix))
		rtn = false;
#else
	if(chdir(prefix))
		rtn = false;
#endif
	return rtn;
}

bool Dir::getPrefix(char *prefix, size_t size)
{
	bool rtn = true;

#ifdef	WIN32
	if(!GetCurrentDirectory((DWORD)size, prefix))
		rtn = false;
#else
	if(getcwd(prefix, size) == NULL)
		rtn = false;
#endif
	return rtn;
}

void Dir::open(const char *fname)
{
#ifdef	WIN32
	size_t len = strlen(fname) + 4;
	char *path;
#endif

	close();
#ifdef WIN32
	DWORD attr = GetFileAttributes(fname);
	if( (attr == (DWORD)~0l) || !(attr & FILE_ATTRIBUTE_DIRECTORY) )
	{
#ifdef	CCXX_EXCEPTIONS
		if(Thread::getException() == Thread::throwObject)
			throw(this);
#ifdef	COMMON_STD_EXCEPTION
		else if(Thread::getException() == Thread::throwException)
			throw(DirException(String(fname) + ": failed"));
#endif
#endif
	}

	path = (char *)alloca(len + 1);
	if(path)
		snprintf(path, len + 1, "%s", fname);
#ifdef	CCXX_EXCEPTIONS
	if (!path && Thread::getException() == Thread::throwObject)
		throw(this);
#ifdef	COMMON_STD_EXCEPTION
	else if(!path && Thread::getException() == Thread::throwException)
		throw(DirException(String(fname) + ": failed"));
#endif
#endif
	addString(path, len, "\\*");
	hDir = FindFirstFile(path, &fdata);
	if(hDir != INVALID_HANDLE_VALUE)
		name = fdata.cFileName;
	memcpy(&data, &fdata, sizeof(fdata));

#else // WIN32
	entry = NULL;
	dir = opendir(fname);
#ifdef	CCXX_EXCEPTIONS
	if(!dir && Thread::getException() == Thread::throwObject)
		throw(this);
#ifdef	COMMON_STD_EXCEPTION
	else if(!dir && Thread::getException() == Thread::throwException)
		throw(DirException(String(fname) + ": failed"));
#endif
#endif
#endif // WIN32
}
	
Dir::~Dir()
{
	close();
}

void Dir::close(void)
{
#ifdef WIN32
	if(hDir != INVALID_HANDLE_VALUE)
		FindClose(hDir);
	hDir = INVALID_HANDLE_VALUE;
#else
	if(dir)
		closedir(dir);
	dir = NULL;
	entry = NULL;
#endif
}

bool Dir::rewind(void)
{
	bool rtn = true;
#ifdef	WIN32
	memcpy(&data, &fdata, sizeof(data));
	name = fdata.cFileName;
#else
	if(!dir)
		rtn = false;
	else 
		rewinddir(dir);
#endif
	return rtn;
}

bool Dir::isValid(void)
{
#ifdef WIN32
	if(hDir == INVALID_HANDLE_VALUE)
#else
	if(!dir)
#endif
		return false;

	return true;
}

const char *Dir::operator*()
{
#ifdef	WIN32
	return name;
#else
	if(!dir)
		return NULL;

	if(!entry)
		return getName();

	return entry->d_name;
#endif
}

const char *Dir::getName(void)
{
#ifdef WIN32
	char *retname = name;

	if(hDir == INVALID_HANDLE_VALUE)
		return NULL;
	
	if(retname)
	{
		name = NULL;
		if(FindNextFile(hDir, &data))
			name = data.cFileName;
	}
	return retname;

#else
	if(!dir)
		return NULL;

#ifdef	HAVE_READDIR_R
	readdir_r(dir, save, &entry);
#else 
	entry = readdir(dir);
#endif
	if(!entry)
		return NULL;

	return entry->d_name;
#endif // WIN32
}

#ifdef	CCXX_NAMESPACES
}
#endif

/** EMACS **
 * Local variables:
 * mode: c++
 * c-basic-offset: 8
 * End:
 */
