#ifndef CDINFO_H
#define CDINFO_H
/*
 * $Id: cdinfo.h,v 1.3.4.1 1999/01/15 08:47:35 dirk Exp $
 *
 * This file is part of WorkMan, the civilized CD player program
 * (c) 1991-1997 by Steven Grimm (original author)
 * (c) by Dirk Frsterling (current 'author' = maintainer)
 * The maintainer can be contacted by his e-mail address:
 * milliByte@DeathsDoor.com 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Prototypes from cdinfo.c
 * 
 * This is just one more step to a more modular and understandable code.
 */

extern char *cur_trackname;		/* Take a guess */
extern int cur_index;			/* Current index mark */
extern int cur_frame;			/* Current frame number */
extern struct play *playlist;		/* = NULL */
extern struct cdinfo_wm thiscd, *cd;	/* = &thiscd */
extern int cur_track;			/* Current track number, starting at 1 */
extern char *cur_artist;		/* Name of current CD's artist */
extern char cur_avoid;			/* Avoid flag */
extern char cur_contd;			/* Continued flag */
extern char *cur_cdname;		/* Album name */
extern int cur_nsections;		/* Number of sections currently defined */
extern int exit_on_eject;
extern int cur_track, cur_pos_abs, cur_pos_rel, cur_tracklen, cur_cdlen, cur_cdmode,
       cur_ntracks, cur_lasttrack, cur_firsttrack, cur_listno;

void	wipe_cdinfo( void );
void	play_next_entry( int forward );
void	make_playlist( int playmode, int starttrack );
int	get_autoplay( void );
int	get_playmode( void );
void	pl_find_track( int track );
void	play_prev_track( int forward );
void	play_next_track( int forward );
int	tracklen( int num );
int	get_default_volume( int track );
int	split_trackinfo( int pos );
int	remove_trackinfo( int num );
void	freeup( char **x );
int	get_runtime( void );
char   *trackname( int num );
void	stash_cdinfo( char *artist, char *cdname, int autoplay, int playmode );
void	stash_trkinfo( int track, char *songname, int contd, int avoid );
int	get_avoid( int num );
int	get_contd( int num );
void	default_volume( int track, int vol );
char   *listentry( int num );

#endif /* CDINFO_H */
