// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _CdromBase_h_
#define _CdromBase_h_

extern "C" {
#include <sys/ioctl.h>
}
#include "CompactDiscID.h"

enum CdromStatus {
	Playing,
	  Paused,
	  Stopped,
	  Completed,
	  Error
};

//: Abstract interface to any CDROM.
//. This class defines the basic interface for a CDROM drive that is supported
//. by XCd.
class CdromBase {
 public:
	//: Eject/retract the drive tray.
	virtual bool eject( int fd ) = 0;
	
	//: Return the ID of the current disc, or 0 if no disc is present.
	virtual CompactDiscID* id( int fd ) = 0;

	//: Perform any necessary initialization of the CDROM device.
	virtual bool init( int fd ) = 0;
	
	//: Pause the playing disc.
	virtual bool pause(int fd ) = 0;
	
	//: Play a single  track on the disc, from start to finish.
	virtual bool play( int fd, int track ) = 0;
	
	//: Resume playing the disc after pausing.
	virtual bool resume( int fd ) = 0;
	
	//: Get the current status of the CDROM drive.
	virtual bool status( int fd, CdromStatus& status, int& absTime, int& volume ) = 0;
	
	//: Stop the playing disc.
	virtual bool stop( int fd ) = 0;
	
	//: Set the output volume of the CDROM drive.
	virtual bool volume( int fd, int vol ) = 0;
};

#endif
