// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "CompactDisc.h"
#include "Database.h"

//------------------------------------------------------------------------------
// Create a CompactDisc.
//------------------------------------------------------------------------------
CompactDisc::CompactDisc( const CompactDiscID& cid, QString& title, QString& artist, QString* tracks, int progLength, int* progTracks ) :
        _id(cid),
        _title(title),
        _artist(artist)
{
	// Create the program.
	if ( progLength ) {
		_program = new Program( progLength, progTracks );
	} else {
		_program = new Program( cid );
	}
	
    // Allocate an array of track names.
    _tracks = new QString[_id.numTracks()];

    // Copy the tracks names.
    for (int i = 0; i < _id.numTracks(); i++) {
        _tracks[i] = tracks[i];
    }
}

CompactDisc::~CompactDisc()
{
	delete [] _tracks;
	delete _program;
}

//------------------------------------------------------------------------------
// Set the disc's title.
//------------------------------------------------------------------------------
void CompactDisc::setTitle(const char* title)
{
    _title = title;
    emit updateTitle(title);
}

//------------------------------------------------------------------------------
// Set the disc's artist.
//------------------------------------------------------------------------------
void CompactDisc::setArtist(const char* artist)
{
    _artist = artist;
    emit updateArtist(artist);
}

//------------------------------------------------------------------------------
// Set the name of a track on the disc.
//------------------------------------------------------------------------------
void CompactDisc::setTrack(int track, const char* name)
{
    _tracks[track] = name;
    emit updateTrack(track, name);
}

//------------------------------------------------------------------------------
// Update the disc's info in the database.
//------------------------------------------------------------------------------
void CompactDisc::saveDiscInfo()
{
    dbase->update( *this );
}

void CompactDisc::changeProgram( int length, int tracks[] )
{
	delete _program;
	_program = new Program( length, tracks );
}
