// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _Database_H_
#define _Database_H_

extern "C" {
#include <stdio.h>
}
#include <qstring.h>
#include <qobject.h>
#include "CompactDisc.h"
#include "CompactDiscID.h"

//: Maintain a database of CompactDiscs.
//. Maintain a collection of CompactDiscs that can be searched and updated by
//. their CompactDiscIDs.  The Database is stored in a file, and it is not
//. loaded into memory (except for updating).
class Database : public QObject {
    Q_OBJECT

	QString getToken( FILE* fp ) const;
    QString getToEOL( FILE* fp ) const;

    //: Read the next CompactDisc entry from the Database file.
    CompactDisc* nextEntry(FILE* fptr) const;

	//: Write a CompactDisc entry to the Database file.
    void writeEntry(FILE* fptr, CompactDisc& cd);

public:
    //: Create the Database from the path to the data file.
	//. "There can be only one."
    Database() { }

    //: Search for a CompactDisc by CompactDiscID.
	//. If the disc is not found in the database file, then a default
	//. CompactDisc will be created and returned.
    CompactDisc* search( const CompactDiscID& id) const;

    //: Add/update the CompactDisc to the Database.
	//. Write the CompactDisc to the database file.  The entire database is
	//. read in.  Then, all entries are rewritten, with the new entry for the
	//. given disc replacing any existing entry for it.
    void update(CompactDisc& cd);
};

// There is exactly one Database.
extern Database* dbase;

#endif
