// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _Options_H_
#define _Options_H_

extern "C" {
#include <stdio.h>
}
#include <qobject.h>
#include <qstring.h>
#include "xcd.h"
#include "CdromType.h"

class Options : public QObject {
	Q_OBJECT
	
	bool       _autoPlay;
	bool       _autoEject;
	bool       _repeat;
	bool       _shuffle;
	TimeMode   _timeMode;
	IconMode   _iconMode;
	CdromType  _cdromType;
	int        _pollTime;
	QString    _cdromPath;
	QString    _dbasePath;

	void        load();
	QString     getToken( FILE* fp );
	TimeMode    stringToTimeMode( const char* str );
	IconMode    stringToIconMode( const char* str );
 public:
	Options( int argc, char* argv[] );
	
	bool        autoPlay()    { return _autoPlay; }
	bool        autoEject()   { return _autoEject; }
	bool        repeat()      { return _repeat; }
	bool        shuffle()     { return _shuffle; }
	TimeMode    timeMode()    { return _timeMode; }
	IconMode    iconMode()    { return _iconMode; }
	CdromType   cdromType()   { return _cdromType; }
	int         pollTime()    { return _pollTime; }
	const char* cdromPath()   { return (const char*)_cdromPath; }
	const char* dbasePath()   { return (const char*)_dbasePath; }
	
	void setAutoPlay( bool b )         { _autoPlay = b; emit updateAutoPlay(); }
	void setAutoEject( bool b )        { _autoEject = b; emit updateAutoEject(); }
	void setRepeat( bool b )           { _repeat = b; emit updateRepeat(); }
	void setShuffle( bool b )          { _shuffle = b; emit updateShuffle(); }
	void setTimeMode( TimeMode m )     { _timeMode = m; emit updateTimeMode(); }
	void setIconMode( IconMode m )     { _iconMode = m; emit updateIconMode(); }
	void setCdromType( CdromType t )   { _cdromType = t; emit updateCdromType(); }
	void setPollTime( int t )          { _pollTime = t; emit updatePollTime(); }
	void setCdromPath( const char* p ) { _cdromPath = p; emit updateCdromPath(); }
	void setDbasePath( const char* p ) { _dbasePath = p; emit updateDbasePath(); }
 public slots:
	void save();
 signals:
	void updateAutoPlay();
	void updateAutoEject();
	void updateRepeat();
	void updateShuffle();
	void updateTimeMode();
	void updateIconMode();
	void updateCdromType();
	void updatePollTime();
	void updateCdromPath();
	void updateDbasePath();
};

extern Options* options;

#endif
