// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

extern "C" {
#include <stdlib.h>
}
#include "Program.h"

Program::Program( const int length, const int* tracks )
: _step( 1 )
{
	_tracks.setAutoDelete( true );
	_orderedTracks.setAutoDelete( true );
	
	for ( int i = 0; i < length; i++ ) {
		_orderedTracks.append( new int( tracks[i] ) );
		_tracks.append( new int( tracks[i] ) );
	}
	
	emit updateStep( _step + 1 );
}

Program::Program( const CompactDiscID& id )
: _step( 1 )
{
	_tracks.setAutoDelete( true );
	_orderedTracks.setAutoDelete( true );
	
	for ( int i = 0; i < id.numTracks(); i++ ) {
		_orderedTracks.append( new int( i + id.firstTrack() ) );
		_tracks.append( new int( i + id.firstTrack() ) );
	}
	
	emit updateStep( _step + 1 );
}

inline int rnd(int x) { return int(double(random()&RAND_MAX)/double(RAND_MAX)*double(x)); }

void Program::shuffle()
{
    int* ip;

    // Go through the tracks list twice for good measure.
    for (unsigned int i = 0; i < 2*_tracks.count(); i++) {
        ip = _tracks.take(rnd(_tracks.count()));
        _tracks.insert(rnd(_tracks.count()+1), ip);
    }
}

void Program::unshuffle()
{
	int* i;
	_tracks.clear();
	
	for ( i = _orderedTracks.first(); i; i = _orderedTracks.next() ) {
		_tracks.append( new int ( *i ) );
	}
}
