// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

extern "C" {
#include <stdlib.h>
#include <time.h>
}
#include <qaccel.h>
#include <qapp.h>
#include <qbitmap.h>
#include "Options.h"
#include "Database.h"
#include "Cdrom.h"
#include "CDDrive.h"
#include "MainWindow.h"
#include "PrefsWindow.h"
#include "InfoWindow.h"

Cdrom*       cdrom = 0;
Options*     options = 0;
Database*    dbase = 0;
PrefsWindow* prefsWindow = 0;
InfoWindow*  infoWindow = 0;

//------------------------------------------------------------------------------
// Start it up!
//------------------------------------------------------------------------------
int main(int argc, char* argv[])
{
    // Seed the random number generator.
    srand(time(0));
    
    QApplication a(argc, argv);

	cdrom            = new Cdrom;
	options          = new Options( argc, argv );
	dbase            = new Database;
    CDDrive* cddrive = new CDDrive;
	prefsWindow      = new PrefsWindow;
    infoWindow       = new InfoWindow;
    MainWindow* mw   = new MainWindow;

    // Connect the Options to everything.
    options->connect( options, SIGNAL( updatePollTime() )  , cddrive, SLOT( changePollTime() ) );
    options->connect( options, SIGNAL( updateShuffle() )   , cddrive, SLOT( changeShuffle() ) );
	options->connect( options, SIGNAL( updateDbasePath() ) , cddrive, SLOT( changeDbasePath() ) );
	
    options->connect( options, SIGNAL( updateCdromPath() ), cdrom, SLOT( changePath() ) );
	options->connect( options, SIGNAL( updateCdromType() ), cdrom, SLOT( changeType() ) );
	cdrom->changePath();
	cdrom->changeType();

    options->connect( options, SIGNAL( updateIconMode() ), mw, SLOT( changeIconMode() ) );
	options->connect( options, SIGNAL( updateShuffle() ) , mw, SLOT( changeShuffle() ) );
	options->connect( options, SIGNAL( updateRepeat() )  , mw, SLOT( changeRepeat() ) );
	options->connect( options, SIGNAL( updateTimeMode() ), mw, SLOT( changeTimeMode() ) );
	
	options->connect( options, SIGNAL( updateShuffle() ) , prefsWindow, SLOT( changeShuffle() ) );
	options->connect( options, SIGNAL( updateRepeat() )  , prefsWindow, SLOT( changeRepeat() ) );
	options->connect( options, SIGNAL( updateTimeMode() ), prefsWindow, SLOT( changeTimeMode() ) );
	options->connect( options, SIGNAL( updateIconMode() ), prefsWindow, SLOT( changeIconMode() ) );

    // Connect the MainWindow to the CDDrive.
    mw->connect( mw, SIGNAL( play() )          , cddrive, SLOT( play() ) );
    mw->connect( mw, SIGNAL( pause() )         , cddrive, SLOT( pause() ) );
    mw->connect( mw, SIGNAL( stop() )          , cddrive, SLOT( stop() ) );
    mw->connect( mw, SIGNAL( eject() )         , cddrive, SLOT( eject() ) );
    mw->connect( mw, SIGNAL( nextTrack() )     , cddrive, SLOT( nextTrack() ) );
    mw->connect( mw, SIGNAL( previousTrack() ) , cddrive, SLOT( previousTrack() ) );
    mw->connect( mw, SIGNAL( incrVolume() )    , cddrive, SLOT( incrVolume() ) );
    mw->connect( mw, SIGNAL( decrVolume() )    , cddrive, SLOT( decrVolume() ) );
    mw->connect( mw, SIGNAL( playTrack(int) )  , cddrive, SLOT( playTrack(int) ) );

    mw->connect( cddrive, SIGNAL( updateStep( int ) )              , mw, SLOT( changeStep( int ) ) );
    mw->connect( cddrive, SIGNAL( updateTrack( int, const char* ) ), mw, SLOT( changeTrack( int, const char* ) ) );
    mw->connect( cddrive, SIGNAL( updateTime( int, int ) )         , mw, SLOT( changeTime( int, int ) ) );
    mw->connect( cddrive, SIGNAL( updateVolume( int) )             , mw, SLOT( changeVolume( int ) ) );
    mw->connect( cddrive, SIGNAL( noDisc() )                       , mw, SLOT( noDisc() ) );
    mw->connect( cddrive, SIGNAL( newDisc( CompactDisc* ) )        , mw, SLOT( newDisc( CompactDisc* ) ) );
	mw->connect( cddrive, SIGNAL( updateStatus( CdromStatus ) )    , mw, SLOT( changeStatus( CdromStatus ) ) );

    // Connect the InfoWindow to the CDDrive.
    infoWindow->connect(cddrive, SIGNAL(noDisc())                 , infoWindow, SLOT(noDisc()));
    infoWindow->connect(cddrive, SIGNAL(newDisc(CompactDisc*))    , infoWindow, SLOT(newDisc(CompactDisc*)));
	infoWindow->connect( infoWindow, SIGNAL( updateProgram( int, int* ) ), cddrive, SLOT( changeProgram( int, int* ) ) );

    // Connect the InfoWindow to the MainWindow.
    infoWindow->connect( infoWindow, SIGNAL(updateDiscTitle(const char*))        , mw, SLOT(changeDiscTitle(const char*)));
    infoWindow->connect( infoWindow, SIGNAL(updateDiscArtist(const char*))       , mw, SLOT(changeDiscArtist(const char*)));
    infoWindow->connect( infoWindow, SIGNAL(updateTrackTitle(int, const char*))  , mw, SLOT(changeTrackTitle(int, const char*)));
	infoWindow->connect( infoWindow, SIGNAL( updateProgram( int, int* ) )        , mw, SLOT( changeProgram( int, int* ) ) );

    // Keyboard accelerators.
    QAccel accel(mw);
    accel.connectItem(accel.insertItem(Key_P)           , cddrive, SLOT(play()));
    accel.connectItem(accel.insertItem(Key_S)           , cddrive, SLOT(stop()));
    accel.connectItem(accel.insertItem(Key_E)           , cddrive, SLOT(eject()));
    accel.connectItem(accel.insertItem(Key_Left)        , cddrive, SLOT(previousTrack()));
    accel.connectItem(accel.insertItem(Key_Right)       , cddrive, SLOT(nextTrack()));
    accel.connectItem(accel.insertItem(Key_Up)          , cddrive, SLOT(incrVolume()));
    accel.connectItem(accel.insertItem(Key_Down)        , cddrive, SLOT(decrVolume()));
    accel.connectItem(accel.insertItem(Key_Q)           , qApp , SLOT(quit()));
	accel.connectItem(accel.insertItem(Key_I)           , mw   , SLOT(nextIconMode()));
	accel.connectItem(accel.insertItem(Key_T)           , mw   , SLOT(nextTimeMode()));

    a.setMainWidget(mw);
    mw->show();
    return a.exec();
}
