// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _xcd_H_
#define _xcd_H_

#if defined(_AIX)
typedef int bool;
enum { false=0, true=1 };
#endif

#define XcdFrames 75
#define XcdSecs   60

//------------------------------------------------------------------------------
// Play modes.
//------------------------------------------------------------------------------
enum PlayMode {
    Normal,
    Shuffle
};

//------------------------------------------------------------------------------
// Repeat modes.
//------------------------------------------------------------------------------
enum RepeatMode {
    None,
    Disc
};

//------------------------------------------------------------------------------
// Time display modes.
//------------------------------------------------------------------------------
enum TimeMode {
    TrackElapsed,
    TrackRemaining,
    DiscElapsed,
    DiscRemaining
};

//------------------------------------------------------------------------------
// Icon display modes.
//------------------------------------------------------------------------------
enum IconMode {
    ProgramName,
    DiscTitle,
    DiscArtist,
    TrackName,
    Time
};

#endif
