/*
     X Workbone CDROM Player
     Copyright (C) 1995 Eric Merth
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     This source file is based in part on Thomas McWilliams' workbone.c,
     his copyright follows....
*/

/*   WorkBone CD Rom Player Software

     Copyright (C) 1993  Thomas McWilliams

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h> 
#include <X11/Xaw/Label.h>

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>
#include <unistd.h>
#include <termios.h>
#include <mntent.h>
#include <getopt.h>
#include "struct.h"
#include "workbone.h"

void rl_ttyset (int Reset);
void strmcpy (char **t, char *s);
void help (void);
inline void playtime (void);

char *cur_trackname;		/* Take a guess */
int cur_index = 0;		/* Current index mark */
int cur_frame;			/* Current frame number */
struct play *playlist = NULL;
struct cdinfo thiscd, *cd = &thiscd;
int cur_track = -1;		/* Current track number, starting at 1 */
char *cur_artist;		/* Name of current CD's artist */
char cur_avoid;			/* Avoid flag */
char cur_contd;			/* Continued flag */
char *cur_cdname;		/* Album name */
int cur_nsections;		/* Number of sections currently defined */
int exit_on_eject = 0;

int cur_balance = 10, info_modified;
int cur_track, cur_pos_abs, cur_pos_rel, cur_tracklen, cur_cdlen, cur_cdmode,
    cur_ntracks, cur_lasttrack, cur_firsttrack, cur_listno;
char tmptime[100];
char *tottime;

/***************************************************************************************************/
/* OK, this function is only defined in X11/IntrinsicP.h so maybe using it will
 * be a bad thing... */

extern void XtResizeWidget(Widget, _XtDimension, _XtDimension, _XtDimension);

/***************************************************************************************************/

Widget rootWidget;
Widget controlWidget[15];

void  rewind_(Widget w, XtPointer clientdat, XtPointer caldat);
void  eject(Widget w, XtPointer clientdat, XtPointer caldat);
void  fastforward(Widget w, XtPointer clientdat, XtPointer caldat);
void  skipback(Widget w, XtPointer clientdat, XtPointer caldat);
void  restart(Widget w, XtPointer clientdat, XtPointer caldat);
void  skipforward(Widget w, XtPointer clientdat, XtPointer caldat);
void  stop(Widget w, XtPointer clientdat, XtPointer caldat);
void  pause_(Widget w, XtPointer clientdat, XtPointer caldat);
void  play(Widget w, XtPointer clientdat, XtPointer caldat);
void  quitandplay(Widget w, XtPointer clientdat, XtPointer caldat);
void  quitandstop(Widget w, XtPointer clientdat, XtPointer caldat);

void  dotquestion(Widget w, XtPointer clientdat, XtPointer caldat);
void  Zero(void);
void  One(void);
void  Two(void);
void  Three(void);
void  Four(void);
void  Five(void);
void  done(void);
void  update(Widget w, XtPointer clientdat, XtPointer caldat);
void control_panel(void);
Boolean theWorkProcedure(XtPointer clientdat);
void resetMainWidgetSize(Widget w, XtPointer xtp, XEvent *event, Boolean *cont_dispatch);
int CDmounted(void);
void message(char *);

int  tmppos;
int save_track;
int sss;
int scmd;
int drv_status; /* is the CD drive available? */

#define CDDRV_OK 100
#define CANT_OPEN 101
#define ALREADY_MOUNTED 102

#define MAINWIDTH 322
#define MAINHEIGHT 158
#ifndef ZERO
#define ZERO 0
#endif

   /***************************************************************************************************/

int main(int argc, char **argv) {

XtAppContext appContext;
String appClass = "Xdisp";
   /****************************************************************************************/
  int dly;
  int fastin = FALSE;
/*   fd_set rset; */
  struct timeval mydelay;
/*
  FILE *fp ;
  struct mntent *mnt ;
 */
  char copt;
  thiscd.trk = NULL;
  thiscd.lists = NULL;
  mydelay.tv_sec = 0;
  mydelay.tv_usec = 200000;
  tottime = tmptime;

  /* Init vars that were moved to global staus */
  save_track = 1;
  tmppos = 0;
  scmd = 0;

   /****************************************************************************************/

   XtSetLanguageProc(NULL, NULL, NULL);
   rootWidget = XtAppInitialize(&appContext, appClass, NULL, 0, &argc, argv, NULL, NULL, 0 );
   XSynchronize(XtDisplay(rootWidget), 1);
   control_panel ();
   XtRealizeWidget(rootWidget);
   /* XtRealizeWidget(controlWidget[0]); */
   XSynchronize(XtDisplay(rootWidget), 0);

   /****************************************************************************************/
  /* get options */
  for (;;)
    {
      if ((copt = getopt (argc, argv, "hqvV")) == EOF)
	break;
      switch (copt)
	{
	case 'q':
	  fastin = TRUE;
	  break;
	default:
	  printf ("\nXWorkBone version 0.1 Copyright 1995 (c) Eric Merth\n");
	  printf ("Free Software under GNU General Public License.\n\n");
	  printf ("Useage:  xworkbone [ -v | -h | -q ]\n");
	  printf ("           -v : version\n");
	  printf ("           -h : help\n");
	  printf ("           -q : fast start (no wait for init)\n\n");
	  printf ("Type 'xworkbone' to start program.\n\n");
	  exit (0);
	}
    }

   drv_status = CDmounted();
   switch(drv_status) {
      case CANT_OPEN:
         printf("Can't seem to open the CDROM device\n");
         break;
      case ALREADY_MOUNTED:
         printf("The CDROM is mounted as a file system\n");
         break;
      default: 
         break;
    }
  /* delay while CD drive initializes itself */
  if (!fastin)
    for (dly = 6; dly > -1; dly--)
      {
	printf (MTAB3 "wait ... initializing %d\r", dly);
	fflush (stdout);
	sleep (1);
      }
  printf (MTAB3 "                         \r");
  fflush (stdout);
  sss = cd_status ();
  rl_ttyset (0);
  if (sss == 0 || sss == 4) {
    done();
  }
  cur_track = 1;

   XtAppAddWorkProc(appContext, theWorkProcedure, NULL);
   XtAppMainLoop(appContext);

   return(0);
}


/****************************************************************************************/


void message(char *m) {
   Arg arg[2];
   arg[0].name = XtNlabel;
   arg[0].value = (XtArgVal) m;
   arg[1].name = XtNwidth;
   arg[1].value = (XtArgVal) 312;
   XtSetValues(controlWidget[13], arg, 2);
}

void resetMainWidgetSize(Widget w, XtPointer xtp, XEvent *event, Boolean *cont_dispatch) {
   XtResizeWidget(rootWidget, MAINWIDTH, MAINHEIGHT, 2);
}

void  dotquestion(Widget w, XtPointer clientdat, XtPointer caldat) {
}

void  rewind_(Widget w, XtPointer clientdat, XtPointer caldat) {
	      if (cur_cdmode == CDPLAY)
		{
		  tmppos = cur_pos_rel - 15;
		  play_cd (cur_track, tmppos > 0 ? tmppos : 0, cur_ntracks + 1);
		}
}

void  eject(Widget w, XtPointer clientdat, XtPointer caldat) {
	      stop_cd ();
	      eject_cd ();
}


void  fastforward(Widget w, XtPointer clientdat, XtPointer caldat) {
	      if (cur_cdmode == CDPLAY)
		{
		  tmppos = cur_pos_rel + 15;
		  if (tmppos < thiscd.trk[cur_track - 1].length)
		    play_cd (cur_track, tmppos, cur_ntracks + 1);
		}
}

void  skipback(Widget w, XtPointer clientdat, XtPointer caldat) {
	      cur_track--;
	      if (cur_track < 1)
		cur_track = cur_ntracks;
	      play_cd (cur_track, 0, cur_ntracks + 1);
}

void  restart(Widget w, XtPointer clientdat, XtPointer caldat) {
	      if (cur_cdmode == CDPLAY)
		play_cd (cur_track, 0, cur_ntracks + 1);
}

void  skipforward(Widget w, XtPointer clientdat, XtPointer caldat) {
	      if (cur_track == cur_ntracks)
		cur_track = 0;
	      play_cd (cur_track + 1, 0, cur_ntracks + 1);
}

void  stop(Widget w, XtPointer clientdat, XtPointer caldat) {
	      save_track = cur_track;
	      stop_cd ();
}

void  pause_(Widget w, XtPointer clientdat, XtPointer caldat) {
	      if (cur_cdmode == CDPLAY || cur_cdmode == CDPAUZ)
		{
		  pause_cd ();
		}
}

void  play(Widget w, XtPointer clientdat, XtPointer caldat) {
	      if (cur_cdmode == CDSTOP || cur_cdmode == CDNULL)
		{
		  play_cd (save_track, 0, cur_ntracks + 1);
		}
}


void  quitandplay(Widget w, XtPointer clientdat, XtPointer caldat) {
   done();
}

void  quitandstop(Widget w, XtPointer clientdat, XtPointer caldat) {
   stop_cd ();
   done();
}

void  done(void) {
  if (thiscd.trk != NULL)
    free (thiscd.trk);
  printf ("\n");
  rl_ttyset (1);
   exit(0);
}

/*************************************************************************/    

void  Zero(void) {
	  cur_track = save_track = 1;
	  message ("Stopped 1");
}

void  One(void) {
	  playtime ();
	  message("Playing");
}

void  Three(void) {
	  message("Paused");
}

void  Four(void) {
	  message("Stopped 2");
}

void  Five(void) {
/*          done();        */
}

void  update(Widget w, XtPointer clientdat, XtPointer caldat) {
      cd_status();
      switch (cur_cdmode)
	{
	case 0:		/* CDNULL */
          Zero();
	  break;
	case 1:		/* CDPLAY */
          One();
	  break;
	case 3:		/* CDPAUZ */
          Three();
	  break;
	case 4:		/* CDSTOP */
          Four();
	  break;
	case 5:		/* CDEJECT */
          Five();
	  break;
	default:
          break;
	}
}


/*************************************************************************/    

int CDmounted(void) {
  FILE *fp ;
  struct mntent *mnt ;

  /*check if drive is mounted (from Mark Buckaway's cdplayer code) */
  if ((fp = setmntent (MOUNTED, "r")) == NULL) {
    cur_cdmode = 5;
    return (CANT_OPEN);
  }
  while ((mnt = getmntent (fp)) != NULL)
    {
      if (strcmp (mnt->mnt_type, "iso9660") == 0) {
          cur_cdmode = 5;
	  endmntent (fp);
          return (ALREADY_MOUNTED);
      }
    }
  endmntent (fp);
  return CDDRV_OK;

  /* check if drive is mounted (from Mark Buckaway's cdplayer code) */
/*  if ((fp = setmntent (MOUNTED, "r")) == NULL)
    {
      fprintf (stderr, "Couldn't open %s: %s\n", MOUNTED, strerror (errno));
      exit (1);
    }
  while ((mnt = getmntent (fp)) != NULL)
    {
      if (strcmp (mnt->mnt_type, "iso9660") == 0)
	{
	  fputs ("CDROM already mounted. Operation aborted.\n", stderr);
	  endmntent (fp);
	  exit (1);
	}
    }
  endmntent (fp);
*/
}


/* takes terminal in and out of raw mode */
void
rl_ttyset (int Reset)
{
  static struct termios old;
  struct termios new;

  if (Reset == 0)
    {
      (void) tcgetattr (0, &old);
      new = old;
      new.c_lflag &= ~(ECHO | ICANON);
      new.c_iflag &= ~(ISTRIP | INPCK);
      (void) tcsetattr (0, TCSANOW, &new);
    }
  else
    (void) tcsetattr (0, TCSANOW, &old);
}


/* Copy into a malloced string. */
void
strmcpy (char **t, char *s)
{
  if (*t != NULL)
    free (*t);

  *t = malloc (strlen (s) + 1);
  if (*t == NULL)
    {
      perror ("strmcpy");
      exit (1);
    }

  (void) strcpy (*t, s);
}

/* ansi codes to clear screen */
void
cls ()
{
  printf ("\033[2J\033[H");
}

/* print help screen */
void
help ()
{
  const char *helplist[] =
  {
    "\376\376", "\tstop                       ",
    "||", "\tpause/resume",
    "|\020", "\tplay",
    "\036\036", "\tre-start current selection",
    "|\021", "\tprevious selection",
    "\020|", "\tnext selection",
    "\021\021", "\tgo backward 15 seconds",
    "\020\020", "\tgo foreward 15 seconds",
    "..", "\tabort workbone",
    "quit", "\texit workbone",
    "?", "\tdisplay help screen", NULL};
  int i = 0;
  cls ();
  while (helplist[i] != NULL)
    {
      printf ("\t\t\t%s%s%s%s\n", "\033(U", helplist[i], GOF, helplist[i + 1]);
      i += 2;
    }
  control_panel ();
}

inline void
playtime (void)
{
  static int mymin, emin;
  static int mysec, esec;
  int tmp = 0;

  if (cur_pos_rel > 0 && (tmp = cur_pos_rel % 60) == mysec)
    return;
  mysec = tmp;
  mymin = cur_pos_rel / 60;
  esec = cur_pos_abs % 60;
  emin = cur_pos_abs / 60;
  sprintf (tmptime, "%s %02d:%02d  %02d:%02d", cur_track > 9 ? " " : "  ",
	   mymin, mysec, emin, esec);
  return;
}



Boolean theWorkProcedure(XtPointer clientdat) {
   sleep(1);
   sss = cd_status();
/*
   if (sss == 0 || sss == 4 || cur_cdmode == CDEJECT) {
      scmd = '0';
      if (sss == 0 || sss == 4)
         done();
   }
 */
   if (cur_cdmode < 1)
      save_track = 1;
   return False;
}
