#ifndef __CD_CONSOLE_H
#define __CD_CONSOLE_H

// possible modes
enum mode { NORMAL, PROGRAMMED };

// possible statuses (sp?)
enum status { NO_CD_INSIDE, STOPPED, PAUSED, PLAYING };

class cd {
public:
    cd(void);                   // initialize stuff
    ~cd();                      // close the cd
    void read_status(void);     // read info about current track etc.
    void play_one(int track);   // play a single track
    void play(void);            // continue playing from where we stopped
    void push_track(int track); // add a new track to be played

    void set_mode(mode m);      // set mode
    mode get_mode(void);        // get mode
    status get_status(void);    // get status

    void stop(void);            // stop
    void pause(void);           // pause
    void resume(void);          // resume
    void eject(void);           // eject
    void set_random(bool r);    // set randomness
    bool get_random(void);      // get randomness
    void set_volume(int vol);   // set volume
    int get_volume(void);       // return volume
    void set_looping(bool l);   // set looping
    bool get_looping(void);     // get looping
    void next(void);            // next track
    int get_tracks(void);       // return number of tracks
    int get_current(void);      // return current track
private:
    enum { MAX_TRACKS = 50 };   // how many tracks max this program can handle
    int m_fd;                   // file descriptor
    mode m_mode;                // mode
    status m_status;            // status
    int m_tracks;               // number of tracks on this cd
    int m_volume;               // volume (scale 0-255)
    bool m_looping;             // looping flag
    bool m_random;              // randomness flag
    int m_track;                // currently playing track
    bool m_one_track_only;      // only play one track

    int m_tr[MAX_TRACKS+1];     // array of tracks to play
    int m_ind;                  // index to current track
    int m_programmed;           // number of programmed tracks

    void open(void);            // open /dev/cdrom
    void close(void);           // close /dev/cdrom
    void new_cd(void);          // new cd in drive, init stuff
    void init_tracks(void);     // init track array
    void play(int track);       // play the track and continue after
                                // it with the current mode
    void clear_tracks(void);    // clear m_tr
    void tracks_played(void);   // called when all tracks in array are played
    void shuffle_tracks(int n); // shuffle m_tr
    void read_info(void);       // read the number of tracks
    void read_volume(void);     // read volume
};

// return number of tracks
inline int cd::get_tracks(void)
{
    return m_tracks;
}

// return current track
inline int cd::get_current(void)
{
    return m_track;
}

// get mode
inline mode cd::get_mode(void)
{
    return m_mode;
}

// get status
inline status cd::get_status(void)
{
    return m_status;
}

// set looping
inline void cd::set_looping(bool l)
{
    m_looping=l;
}

// get looping
inline bool cd::get_looping(void)
{
    return m_looping;
}

// get randomness
inline bool cd::get_random(void)
{
    return m_random;
}

#endif // __CD_CONSOLE_H

