/* cd-rom.h	Flavio Lerda		97-07-27 */

/*
	cdplayer 0.2 - simple cdplayer with shuffle and database capability
	Copyright (C) 1997,98  Flavio Lerda

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        To contact the author:
                Flavio Lerda
                Via vittime di Bologna 14
                12026 Piasco CN
                Italy
        or:
                flerda@athena.polito.it
*/   

/*
   Utilities for the manegement of the CD-ROM.
   Inspirated by Linux kernel and the WorkBone
   sources.

   97-07-27: [MAS]	Code written for the first time.
*/

#ifndef __CD_ROM_H
#define __CD_ROM_H

#include <sys/types.h>

/* possible cdrom audio statuss */
#define CDS_PLAY	0
#define CDS_PAUSE	1
#define CDS_STOP	2
#define CDS_OPEN	3
#define CDS_EMPTY	4

struct cd {
	int	fd;
	char	*dev;
};

struct cdrom_entry {
	int	track;		/* number of the track */
	int	audio;		/* true if it's an audio track */
	int	lba_start;	/* start position of the track */
	int	lba_length;	/* length of the track */
	int	lba_end;	/* end position of the track */
};

struct cdrom_toc {
	int			first_track;	/* first track in the CDROM */
	int			last_track;	/* last track in the CDROM */
	int			ntracks;	/* number of tracks */
	int			lba_start;	/* start of the CDROM */
	int			lba_length;	/* length of the CDROM */
	int			lba_end;	/* end of the CDROM */
	char			upc[14];	/* universal product code */
	struct cdrom_entry	*entries;	/* entries for all the tracks */
};

struct cdrom_status {
	int	status;		/* current status of the CDROM */
	int	track;		/* track currently playing */
	int	index;		/* index currently playing */
	int	lba_pos_rel;	/* position relative to the track */
	int	lba_pos_abs;	/* position absolute in the CDROM */
};

/* initialize the cdrom and return an handle to give to other functions */
struct cd	*cdrom_init(char *,int);

/* delete the handle created */
int	cdrom_done(struct cd *);

/* read and allocate a new table of contents */
struct cdrom_toc	*cdrom_toc(struct cd *);

/* free a table of contents */
int	cdrom_freetoc(struct cdrom_toc *);

/* get the current status of the cdrom */
int	cdrom_status(struct cd *,struct cdrom_status *);

/* pause, stop, resume, close or eject the CDROM */
int	cdrom_pause(struct cd *);
int	cdrom_stop(struct cd *);
int	cdrom_resume(struct cd *);
int	cdrom_close(struct cd *);
int	cdrom_eject(struct cd *);

/* set or get the volume */
int	cdrom_setvolume(struct cd *,int,int);
int	cdrom_getvolume(struct cd *,int *,int *);

/* play a given amount of CDROM */
int	cdrom_play(struct cd *,int,int);

/* play a given track */
int	cdrom_playtrack(struct cd *,int);

/* lock or unlock the cdrom */
int	cdrom_lock(struct cd *);
int	cdrom_unlock(struct cd *);

/* get the locking status for this process */
int	cdrom_locked(struct cd *);

/* conversion from/to lba */
void	lba2msf(int,u_char *,u_char *,u_char *);
void	msf2lba(u_char,u_char,u_char,int *);

#endif /* __CD_ROM_H */

/* cd-rom.h	Flavio Lerda		97-07-27 */
