/* cddb.h		Flavio Lerda		97-07-29 */

/*
	cdplayer 0.2 - simple cdplayer with shuffle and database capability
	Copyright (C) 1997  Flavio Lerda

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        To contact the author:
                Flavio Lerda
                Via vittime di Bologna 14
                12026 Piasco CN
                Italy
        or:
                flerda@athena.polito.it
*/   

/*
   Functions for the cd database.
   
   97-07-29: [MAS]	Code written for the first time.
*/

#ifndef __CDDB_H
#define __CDDB_H

#define CDDB_TF_SKIP	1

#define CDDB_DIR	".cddb"

struct cddb_track {
	int			track;		/* number of the track on CD */
	char			*name;		/* name of the track */
	char			*lyrics;	/* name of the file of the lyrics */
	int			flags;		/* not used yet */
};

struct cddb_id {
	char			id[16];		/* identifier of the CD */
};

struct cddb {
	int			ntracks;	/* number of tracks on CD */ 
	char			*title;		/* title of the CD */
	char			*artist;	/* artist on the CD */
	int			flags;		/* not used yet */
	struct cddb_id		id;		/* identifier of the CD */
	struct cddb_track	*tracks;	/* information about tracks */
};

#define	cddb_title(cddb)	((cddb) ? cddb->title : NULL)
#define cddb_artist(cddb)	((cddb) ? cddb->artist : NULL)
#define cddb_ntracks(cddb)	((cddb) ? cddb->ntracks : 0)
#define cddb_flags(cddb)	((cddb) ? cddb->flags : 0)

struct cddb	*cddb_load(struct cddb_id *);
struct cddb	*cddb_new(struct cddb_id *,int,int);
int	cddb_save(struct cddb *);
void	cddb_free(struct cddb *);

char	*cddb_trackname(struct cddb *,int);
int	cddb_trackflags(struct cddb *,int);

char	*cddb_file(char *);
char	*cddb_lyrics(struct cddb *,int);

#endif /* __CDDB_H */

/* cddb.h		Flavio Lerda		97-07-29 */
