/* lyrics.c		Flavio Lerda		98-06-27 */

/*
	cdplayer 0.2 - simple cdplayer with shuffle and database capability
	Copyright (C) 1997  Flavio Lerda

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        To contact the author:
                Flavio Lerda
                Via vittime di Bologna 14
                12026 Piasco CN
                Italy
        or:
                flerda@athena.polito.it
*/   

/*
   Functions for the lyrics.
   
   98-06-27: [MAS]	Code written for the first time.
*/

#include "lyrics.h"
#include "screen.h"
#include "strutil.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define MAXLEN 80

/* Local functions */
static lyrics_line *new(char *);

/* load a lyric from a file */
lyrics_line	*lyrics_load(char *fname)
{
	FILE *fp;
	lyrics_line *head, *tail;
	char buffer[MAXLEN+1];
	
	fp = fopen(fname, "r");
	
	if(fp == NULL) return NULL;
	
	head = tail = NULL;
	
	while(readline(fp, buffer, MAXLEN))
		if(tail == NULL)
			head = tail = new(buffer);
		else {
			tail->ll_next = new(buffer);
			tail->ll_next->ll_prev = tail;
			tail = tail->ll_next;
		}
	
	fclose(fp);
	
	return head;
}

/* dispose the memory allocated for this lyric */
void		lyrics_unload(lyrics_line *l)
{
	while(l) {
		lyrics_line *p = l;
		
		l = l->ll_next;
		
		if(p->ll_data) free(p->ll_data);
		free(p);
	}
}

/* print the lyric in a window starting from a given line */
void		lyrics_wprint(WINDOW *w, lyrics_line *l,int f,int h, int sc, int nc)
{
	int i, x, y;
	
	screen_wfill(w, ' ');
	if(l == NULL) return;
	
	while(f-- > 0)
		if(l) l = l->ll_next;
	
	getmaxyx(w, y, x);
	
	for(i = 0; i < y; i++) {
		screen_wmove(w, 0, i);
		
		if(l) {
			if(h == i)
				screen_wattr(w, sc);
			else
				screen_wattr(w, nc);

			if(l->ll_data) waddnstr(w, l->ll_data, x);
			l = l->ll_next;
		}
	}
}

static lyrics_line *new(char *s)
{
	lyrics_line *p = (lyrics_line *)malloc(sizeof(lyrics_line));

	if(p == NULL) return NULL;
	
	p->ll_next = p->ll_prev = NULL;
	if(s)
		p->ll_data = strdup(s);
	else
		p->ll_data = NULL;
	
	return p;
}

/* returns the length (number of lines) of a lyric */
int		lyrics_length(lyrics_line *l)
{
	int c = 0;
	
	while(l) {
		c++;
		l = l->ll_next;
	}
	
	return c;
}

/* lyrics.c		Flavio Lerda		98-06-27 */
