/* lyrics.h		Flavio Lerda		98-06-27 */

/*
	cdplayer 0.2 - simple cdplayer with shuffle and database capability
	Copyright (C) 1997  Flavio Lerda

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        To contact the author:
                Flavio Lerda
                Via vittime di Bologna 14
                12026 Piasco CN
                Italy
        or:
                flerda@athena.polito.it
*/   

/*
   Functions for the lyrics.
   
   98-06-27: [MAS]	Code written for the first time.
*/

#ifndef __LYRICS_H
#define __LYRICS_H

#include <ncurses.h>

typedef struct lyrics_line {
	struct lyrics_line *ll_next;	/* pointer to next line */
	struct lyrics_line *ll_prev;	/* pointer to previous line */
	char *ll_data;			/* data contained in this line */
} lyrics_line;

/* load a lyric from a file */
lyrics_line	*lyrics_load(char *);
/* dispose the memory allocated for this lyric */
void		lyrics_unload(lyrics_line *);
/* print the lyric in a window starting from a given line */
void		lyrics_wprint(WINDOW *, lyrics_line *,int,int,int,int);
/* returns the length (number of lines) of a lyric */
int		lyrics_length(lyrics_line *);

#endif /* __LYRICS_H */

/* lyrics.h		Flavio Lerda		98-06-27 */
