/* screen.c		Flavio Lerda		98-06-26 */

/*
	cdplayer 0.2 - simple cdplayer with shuffle and database capability
	Copyright (C) 1997  Flavio Lerda

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        To contact the author:
                Flavio Lerda
                Via vittime di Bologna 14
                12026 Piasco CN
                Italy
        or:
                flerda@athena.polito.it
*/   

/*
   Functions to handle screen render
   
   98-06-26: [MAS]	Code written for the first time.
*/

#include "screen.h"
#include <stdarg.h>
#include <stdlib.h>

static int nattrs = 0;
static int *colors = NULL;

void	screen_init(void)
{
	initscr();
	cbreak();
	noecho();
	idlok(stdscr, TRUE);
	scrollok(stdscr, TRUE);

	if(has_colors()) start_color();
	nonl();
	curs_set(0);
	nodelay(stdscr, TRUE);
	intrflush(stdscr, FALSE);
	keypad(stdscr, TRUE);
}

void	screen_done(void)
{
	nattrs = 0;
	if(colors) free(colors);
	clear();
	refresh();
	endwin();
}

void	screen_moverel(int dx,int dy)
{
	int	x, y;

	getyx(stdscr, y, x);
	move(y + dy, x + dx);
}

int	screen_kbhit(void)
{
	int	c;

	if((c = getch()) != ERR)
		ungetch(c);
	
	return c != ERR;
}

int	screen_getkey(void)
{
	int	c;

	while((c = getch()) == ERR)
		;
	
	return c;
}

int	screen_printf(char *fmt, ...)
{
	va_list ap;
	int	r;
	
	va_start(ap, fmt);
	r = vw_printw(stdscr, fmt, ap);
	va_end(ap);
	
	return r;
}

void	screen_colors(color *c)
{
	int i;

	if(colors) free(colors);

	nattrs = c[0].fgterm;
	colors = (int *)malloc(sizeof(int) * (nattrs + 1));
	
	if(colors == NULL) {
		nattrs = 0;
		return;
	}

	if(has_colors())
		for(i = 1; i <= nattrs; i++) {
			init_pair(i, c[i].fgterm, c[i].bgterm);
			colors[i] = COLOR_PAIR(i) | c[i].cterm;
		}
	else
		for(i = 1; i <= nattrs; i++)
			colors[i] = c[i].term;
}

int	screen_wprintf(WINDOW *w, char *fmt, ...)
{
	va_list ap;
	int	r;
	
	va_start(ap, fmt);
	r = vw_printw(w, fmt, ap);
	va_end(ap);
	
	return r;
}

void	screen_wattr(WINDOW *w, int a)
{
	wattrset(w, A_NORMAL);
	if(a <= 0 || a > nattrs) return;

	wattron(w, colors[a]); 
}

void	screen_delwin(WINDOW *w)
{
	wrefresh(w);
	delwin(w);
}

void	screen_wfill(WINDOW *w, char ch)
{
	int x, y, i, j;

	getmaxyx(w, y, x);

	for(i = 0; i < y; i++) {
		wmove(w, i, 0);
		for(j = 0; j < x; j++)
			waddch(w, ch);
	}
}

/* screen.c		Flavio Lerda		98-06-26 */
