/* screen.h		Flavio Lerda		98-06-26 */

/*
	cdplayer 0.2 - simple cdplayer with shuffle and database capability
	Copyright (C) 1997  Flavio Lerda

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        To contact the author:
                Flavio Lerda
                Via vittime di Bologna 14
                12026 Piasco CN
                Italy
        or:
                flerda@athena.polito.it
*/   

/*
   Functions to handle screen render
   
   98-06-26: [MAS]	Code written for the first time.
*/

#ifndef __SCREEN_H
#define __SCREEN_H

#include <ncurses.h>

typedef struct {
	int	fgterm;
	int	bgterm;
	int	cterm;
	int	term;
} color;

void	screen_init(void);
void	screen_done(void);
void	screen_moverel(int,int);
int	screen_kbhit(void);
int	screen_getkey(void);
void	screen_colors(color *);
int	screen_printf(char *, ...);
int	screen_wprintf(WINDOW *, char *, ...);
void	screen_wattr(WINDOW *, int);
void	screen_delwin(WINDOW *);
void	screen_wfill(WINDOW *, char);

#define screen_clear()			clear()
#define screen_clreol()			clrtoeol()
#define screen_newwin(x,y,xs,ys)	newwin((ys),(xs),(y),(x))
#define screen_attr(a)			screen_wattr(stdscr,(a))
#define screen_refresh()		refresh()
#define screen_wrefresh(w)		wrefresh((w))
#define screen_addch(c)			addch((c))
#define screen_waddch(w,c)		waddch((w),(c))
#define screen_wmove(w,x,y)		wmove((w),(y),(x))

#endif /* __SCREEN_H */

/* screen.h		Flavio Lerda		98-06-26 */
