/* strutil.c		Flavio Lerda		97-07-19 */

/*
	cdplayer 0.2 - simple cdplayer with shuffle and database capability
	Copyright (C) 1997,98  Flavio Lerda

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        To contact the author:
                Flavio Lerda
                Via vittime di Bologna 14
                12026 Piasco CN
                Italy
        or:
                flerda@athena.polito.it
*/   

/*
   Some utilities to handle text files and strings.
   
   97-07-19: [MAS]	Code written for the first time
*/

#include "strutil.h"
#include <ctype.h>
#include <ncurses.h>
#include <malloc.h>
#include <string.h>

int	readline(FILE *fp,char *buf,int maxlen) {
        int     c, idx = 0, escape = FALSE;

	bzero(buf,maxlen+1);
        for(c = getc(fp);c != EOF && (escape || c != '\n');c = getc(fp))
                if(escape) {
                        if(c != '\n') {
                                if(idx < maxlen) buf[idx++] = '\\';
                                if(idx < maxlen) buf[idx++] = c;
                        }
                        escape = FALSE;
                } else if(c == '\\')
                        escape = TRUE;
                else
                        if(idx < maxlen) buf[idx++] = c;

        buf[idx] = 0;

        return c != EOF || idx != 0;
}

void    delete_trailing_spaces(char *buf) {
        char    *p;

        for(p = buf;*p && isspace(*p);p++)
                ;

        if(p != buf) {
                char    *copy;

                copy = malloc(strlen(buf));
                strcpy(copy,p);
                strcpy(buf,copy);
                free(copy);
        }
}

void    delete_ending_spaces(char *buf) {
        char    *p;

        for(p = buf + strlen(buf);p != buf && isspace(*p);p--)
                ;

        p[1] = 0;
}

char     *extract(char *start,char *end) {
	char    *p;

	if(start == NULL) return NULL;

	if(end == NULL) end = start + strlen(start);

	if((p = malloc(end - start + 1)) == NULL)
		return NULL;

	memcpy(p,start,end - start);

	p[end - start] = 0;

	return p;
}

/* strutil.c		Flavio Lerda		97-07-19 */
