#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/soundcard.h>

#include "mixer.h"

/* Returns 0 on success, -1 on error. 
   mixer->devname must be non-null.   */
int mix_init_mixer( mixer_str* mixer )
{
 	int tmp;
	int tmp2;
	
	mixer->fd = open( mixer->devname, O_RDWR );
	if( mixer->fd < 0 )
		return -1;
	
	tmp = ioctl( mixer->fd, MIXER_READ(SOUND_MIXER_VOLUME), &tmp2 );
	if( tmp < 0 )
		return -1;

	return 0;
}	

/* Returns -1 on error, 0 on success. Fills setting, 
   setting->device must be filled.  */
int mix_get_setting( mixer_str* mixer, mixer_setting_str* setting )
{
	int tmp;
	int vol;
	
	tmp = ioctl( mixer->fd, MIXER_READ(setting->device), &vol );
	
	setting->left = vol & 0x7F; 
	setting->right= (vol >> 8) & 0x7F;
	
	return tmp;
}

/* Returns -1 on error, 0 on success, 
   setting must be filled.  */
int mix_set_setting( mixer_str* mixer, mixer_setting_str* setting )
{
	int tmp;
	int vol;
	
	vol = (setting->right << 8) | setting->left;
	tmp = ioctl( mixer->fd, MIXER_WRITE(setting->device), &vol );
	
	return tmp;
}
