#ifndef TCD_MIXER_H
#define TCD_MIXER_H

typedef struct {
	/* Usually /dev/mixer */
	char devname[20];
	
	/* File handle */
	int fd;

	/* Various masks */
	int recmask;
	int devmask;
	int stereodevs;
	int recsrc;
} mixer_str;

typedef struct {
	int left;
	int right;
//	int ch0, ch1, ch2, ch3;
	int device;
} mixer_setting_str;

int mix_init_mixer( mixer_str * mixer );
int mix_get_setting( mixer_str * mixer, mixer_setting_str* setting );
int mix_set_setting( mixer_str* mixer, mixer_setting_str* setting );

#endif
