#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>
#include <stdarg.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <linux/cdrom.h>

#include "cdrom.h"
#include "cddb.h"
#include "socket.h"

int main( int argc, char** argv )
{
	int i;
	FILE *outfile;
	cddb_query_str query;
	cddb_server server;
	char s[200];
	char test[200];
	int r=1;

	cd_struct cd;
	
	cd.cdpath = malloc( 50 );
	strcpy( cd.cdpath, "/dev/cdrom" );
        tcd_init_disc(&cd);

	strcpy( server.hostname, "cddb.cddb.com" );
	server.port = 888;

	if( tcd_open_cddb( &server ) != 0 )
	{
		printf( "tcd_open_cddb error: %s\n", server.error );
		exit(-1);
	}
	
	// Send the query
	tcd_formatquery( &cd, test );
	printf("-> %s", test );
	r = send( server.socket, test, strlen(test), 0 );

	tcd_getquery( &server, &query );
	printf( "Query: %s\n", query.categ );
	printf( "Query: %s\n", query.discid );
	printf( "Query: %d\n", query.code );
	printf( "Query: %s\n", query.dtitle );

	sprintf( test, "cddb read %s %s\n", query.categ, query.discid );
	send( server.socket, test, strlen(test), 0 );

	sprintf( test, "%s/.tcd/%s", getenv("HOME"),query.discid );
	printf( "test = %s\n", test );
	outfile = fopen( test, "w" );

	do
	{
		fgetsock( s, 80, server.socket );
		fprintf( outfile, "%s\n", s );
		fprintf( stdout, "%s\n", s );
	} while( strcmp( ".", s ) );

	close(server.socket);
	
}
 