/*****************************************************************************/
/*	xtcd - CD player for X				                     */
/*	Version 0.5                                                          */
/*	By Tim Gerla                                                         */
/*	timg@means.net                                                       */
/*	http://www.cjnetworks.com/~coryb/timg/                               */
/*	Based on asmodem                                                     */
/*	                                                                     */
/*	asmodem - AfterStep PPP					     	     */
/*	Version .5 						             */
/*	By Rob Malda							     */		
/*	malda@cs.hope.edu						     */
/*	http://www.cs.hope.edu/~malda/					     */
/*      based Almost Entirely on AfterStep Mail				     */
/*									     */
/*	asmail - AfterStep Mail		                                     */
/*	Version 0.31				                             */
/*	By Per Liden			                                     */
/*	pt95pli@student.hk-r.se		                                     */
/*	http://www.rby.hk-r.se/~pt95pli	                                     */
/*					                                     */
/*****************************************************************************/

/* SEE COPYING FOR LICENSE */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/cursorfont.h>
#include <linux/cdrom.h>
#include <linux/soundcard.h>

#include "cdrom.h"
#include "mixer.h"
#include "config.h"

cd_struct *cd;
mixer_str mixer;

/* XPM struct and icons ******************************************************/
typedef struct _XpmIcon {
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
} XpmIcon;

XpmIcon UI;

#include "XPM/ui.xpm"

/* Functions *****************************************************************/
void move_or_focus(int x, int y);
void	CreateWindow(void);
void	ParseCmdLine(int argc, char *argv[]);
void	MainLoop();
void	GetXPM(void);
int	FlushExpose(Window w);
void	RedrawWindow( XpmIcon *v);
Pixel	GetColor(char *name);
void 	Done( void );
int	IsInside( int mx, int my, int tx, int ty, int tw, int th );
void 	DrawMixer( Pixmap Buffer );
void 	where_click( int x, int y, int button, int clicktype );

void	prev_track(int x, int y, int type);
void	next_track(int x, int y, int type) ;
void	fast_forward(int x, int y, int type);
void	x_rewind(int x, int y, int type);
void	stop(int x, int y, int type);
void	play(int x, int y, int type);
void	x_pause( int x, int y, int type); 
void 	quit( int x, int y, int type);
void	eject( int x, int y, int type);
void	setmixer( int x, int y, int button );

/* Global stuff **************************************************************/
#define TRUE 1
#define FALSE 0
#define ON 1
#define OFF 0
#define PUSHED 0
#define RELEASED 1

#define TRACKINFO 0
#define TIMEINFO 1

#define UI_X 300
#define UI_Y 150

#define PREV_TRACK(x,y) IsInside( x,y, 5,  75, 30, 30 )
#define REWIND(x,y) 	IsInside( x,y, 40, 75, 30, 30 )
#define FAST_FWRD(x,y) 	IsInside( x,y, 75, 75, 30, 30 )
#define NEXT_TRACK(x,y) IsInside( x,y, 110,75, 30, 30 )

#define STOP(x,y)	IsInside( x,y, 5,  110, 30, 30 )
#define PLAY(x,y) 	IsInside( x,y, 40, 110, 30, 30 )
#define PAUSE(x,y)  	IsInside( x,y, 75, 110, 30, 30 )
#define QUIT(x,y) 	IsInside( x,y, 110,130, 30, 12 )
#define EJECT(x,y)	IsInside( x,y, 110,110, 30, 12)

#define MIXER(x,y)	IsInside( x,y, 155, 129, 192, 145 )

Display	*Disp;	 
Window	Root;
Window	Iconwin;
Window	Win;
Pixmap  Buffer;
Pixmap  Under[2];
char	*Geometry= 0;
int	Shape = 0;
int	hicolor=0;
int     withdrawn= FALSE;
int	iconsfromfile= FALSE;
GC	WinGC;
int	isclicked, clickx, clicky, clickw, clickh;
int	ismixer=TRUE, dirty=TRUE, istrackdirty=TRUE;
int	last_t, needsredraw=TRUE, firsttry=TRUE;

/*****************************************************************************/
int main(int argc,char* argv[])
{       	
	int res;
	
	cd = (cd_struct*)malloc( sizeof(cd_struct) );
	cd->cdpath = (char*)malloc(50);
	strcpy( cd->cdpath, CDROM_PATH );
	strcpy( mixer.devname, MIXER_PATH );

	ParseCmdLine(argc, argv);      
	CreateWindow();
        XSetCommand(Disp,Win,argv,argc); 

	res = mix_init_mixer(&mixer);
	if( res == -1 ) ismixer=FALSE;

	if( tcd_init_disc(cd) == -1 )
	{
		Done();
		fprintf( stderr,"Cannot open /dev/cdrom. Make sure that it exists, and that you\n" );
		fprintf( stderr,"have permission to read and write it. Exiting.\n" );		
		exit(-1);
	}	
//	dirty=TRUE;
//	istrackdirty=FALSE;
//	RedrawWindow(&UI);
//	XCopyArea( Disp, Buffer, Under[TRACKINFO], WinGC, 0,0, 300, 70,0,0 );
	
	MainLoop();
	return 0;
}

/*****************************************************************************/
void Help()
{       
	fprintf(stderr,"xtcd - Version 0.5\n");
	fprintf(stderr,"usage:  xtcd [-options ...] \n");
	fprintf(stderr,"options:\n");
//	fprintf(stderr,"	-d device		CDROM device\n" );
	fprintf(stderr,"        -G [+|-]x[+|-]y  	Position of xtcd\n");
	fprintf(stderr,"\n");       
	exit(1);
}

/****************************************************************************/
void CreateWindow(void)
{
	int i;
	unsigned int borderwidth ;
	char *display_name = NULL; 
	char *wname = "xtcd";
	XGCValues gcv;
	unsigned long gcm;
	XTextProperty name;
	Pixel back_pix, fore_pix, third_pix;
	int screen;	
	int x_fd;
	int d_depth;
	int ScreenWidth, ScreenHeight;
	XSizeHints SizeHints;
	XWMHints WmHints;
        XClassHint classHint;
	XSetWindowAttributes win_attrib;
	
	/* Open display */
	if (!(Disp = XOpenDisplay(display_name)))  
	{ 
		fprintf(stderr,"xtcd: can't open display %s\n", 
			XDisplayName(display_name)); 
		exit (1); 
	} 
	
	screen = DefaultScreen(Disp);
	Root = RootWindow(Disp, screen);
	d_depth = DefaultDepth(Disp, screen);
	x_fd = XConnectionNumber(Disp);	
	ScreenHeight = DisplayHeight(Disp,screen);
	ScreenWidth = DisplayWidth(Disp,screen);
	       
	GetXPM();
		
	SizeHints.flags= PSize|PPosition|PMinSize|PMaxSize;
	SizeHints.x = 0;
	SizeHints.y = 0;	
	back_pix = GetColor("black");
	fore_pix = GetColor("black");
 	third_pix = GetColor("white");	
	XWMGeometry(Disp, screen, Geometry, NULL, (borderwidth =1), &SizeHints,
		    &SizeHints.x,&SizeHints.y,&SizeHints.width,
		    &SizeHints.height, &i); 	
	SizeHints.width = SizeHints.min_width = UI_X;
	SizeHints.height= SizeHints.min_height= UI_Y;	
	SizeHints.max_width = UI_X;
	SizeHints.max_height = UI_Y;
	
	win_attrib.background_pixel=back_pix;
	win_attrib.border_pixel=fore_pix;
	win_attrib.override_redirect=1;
	
	Win = XCreateWindow(Disp, Root, SizeHints.x, SizeHints.y,
				  SizeHints.width, SizeHints.height,
				  borderwidth, d_depth, CopyFromParent, CopyFromParent,
				  /*CWBackPixel|*/CWBorderPixel|CWOverrideRedirect, &win_attrib);


	Buffer = XCreatePixmap(Disp, Win, 300, 150, d_depth ); 
	Under[0]=XCreatePixmap(Disp, Win, 300, 70,  d_depth );
	Under[1]=XCreatePixmap(Disp, Win, 145, 85,  d_depth );

	classHint.res_name =  "xtcd";
        classHint.res_class = "xtcd";
        XSetClassHint(Disp, Win, &classHint);     

	XSetWMNormalHints(Disp, Win, &SizeHints);
	XSelectInput(Disp, Win, (ExposureMask | ButtonPressMask | 
				 StructureNotifyMask | ButtonReleaseMask |
				 ResizeRedirectMask | PointerMotionMask));
	if (XStringListToTextProperty(&wname, 1, &name) ==0) 
	{
		fprintf(stderr, "xtcd: can't allocate window name\n");
		exit(-1);
	}
	XSetWMName(Disp, Win, &name);
	
	/* Create WinGC */
	gcm = GCForeground|GCBackground|GCGraphicsExposures;
	gcv.foreground = fore_pix;
	gcv.background = back_pix;
	gcv.graphics_exposures = True;
	WinGC = XCreateGC(Disp, Root, gcm, &gcv);  


        WmHints.initial_state = withdrawn?WithdrawnState:NormalState;

        WmHints.window_group = Win;
        WmHints.flags = StateHint | IconWindowHint | IconPositionHint
          | WindowGroupHint;

	WmHints.icon_window = None;
	WmHints.icon_x = 0;
	WmHints.icon_y = 0;
	XSetWMHints(Disp, Win, &WmHints); 	

	XSetIconName(Disp, Win, "XTCD" );
	XMapWindow(Disp,Win);
}

/****************************************************************************/
void ParseCmdLine(int argc, char *argv[])
{

	char *Argument;
	int i;       
	
	for(i = 1; i < argc; i++) 
	{
		Argument = argv[i];
		
		if (Argument[0] == '-') 
		{
			switch(Argument[1]) 
			{
//			 case 'd': /* FIXME */
//			 	break;
			 case 'g':
				if(++i >= argc) Help();
				//Geometry = argv[i];
				continue;
			 default:
				Help();
			}
		}
		else
			Help();
	}
}

/****************************************************************************/
void MainLoop()
{
	XEvent Event;            
	int x=0,y=0;
	time_t t1,t2;
		
	t1 = time(NULL);
	t2 = t1;	
			      
	/* Main loop */
	while(1)
	{		
		/* Check events */
		while (XPending(Disp))
		{
			XNextEvent(Disp,&Event);
			switch(Event.type)
			{		     
			 case Expose:		/* Redraw window */
				if(Event.xexpose.count == 0)
					RedrawWindow(&UI); 
				break;		     
			 case ButtonPress:	/* Mouseclick */
				x = Event.xbutton.x;
				y = Event.xbutton.y;
			 	if(!(PREV_TRACK(x,y) || NEXT_TRACK(x,y) || FAST_FWRD(x,y) || REWIND(x,y) ||
				STOP(x,y) || PLAY(x,y) || PAUSE(x,y) || EJECT(x,y) || QUIT(x,y) ||
				MIXER(x,y)))
				{
					move_or_focus(x,y);
					continue;
				}
				if( MIXER(x,y) && ismixer )
					setmixer( x,y, Event.xbutton.button );
				isclicked=FALSE;
			 	switch( Event.xbutton.button )
			 	{
			 	 case Button1:
					needsredraw=TRUE;
//					where_click( x,y,Button1,PUSHED );
					break;
				 case Button2:
				}
//				needsredraw=TRUE;
				break;
			 case ButtonRelease:
				switch( Event.xbutton.button )
				{
				 case Button1:
					needsredraw=TRUE;
				 	where_click( x,y,Button1,RELEASED );
				 	break;
				}
				break;
			 case DestroyNotify:	/* Destroy window */
				Done();
				exit(0);
				break;			

			}
		}
		XFlush(Disp);
/* Got this little snippet out of ASClock */
#ifdef SYS_V
			poll((struct poll *) 0, (size_t) 0, 50);
#else
			usleep(50000L);
#endif
		
		tcd_gettime(cd);
		t2=time(NULL);
		if( t1!=t2 )
		{
			needsredraw=TRUE;
			t1=time(NULL);
			if( cd->err || !cd->isdisk || !cd->isplayable)
			{
				if( firsttry )
				{
					firsttry=FALSE;
					fprintf( stderr, "Trying to reopen drive...\n" );
				}
				else
					putc( '.', stderr );
				tcd_close_disc(cd);
				tcd_init_disc(cd);
				tcd_readdiskinfo(cd);
			}
			XSetIconName(Disp, Win, cd->trk[cd->cur_t].name );
		}                                
		if( needsredraw==TRUE ) RedrawWindow(&UI);
	}
}

void where_click( int x, int y, int button, int clicktype )
{
	if( PREV_TRACK(x,y) ) {	prev_track(x,y,clicktype);return;}
	if( NEXT_TRACK(x,y) ) {	next_track(x,y,clicktype);return;}
	if( FAST_FWRD(x,y) )  {	fast_forward(x,y,clicktype);return;}	
	if( REWIND(x,y) )     {	x_rewind(x,y,clicktype);return;}
	if( STOP(x,y) )       {	stop(x,y,clicktype);return;}
	if( PLAY(x,y) )       {	play(x,y,clicktype);return;}
	if( PAUSE(x,y) )      {	x_pause(x,y,clicktype);return;}
	if( EJECT(x,y) )      {	eject(x,y,clicktype);return;}
	if( QUIT(x,y) )	      { quit(x,y,clicktype);return;}
}

void Done( void )
{
	XFreeGC(Disp, WinGC);
	XFreePixmap( Disp, Buffer );
	XDestroyWindow(Disp, Win);
	XCloseDisplay(Disp);
	tcd_close_disc(cd);
}
	
/****************************************************************************/
void GetXPM(void)
{
	char **icon;
	XWindowAttributes Attributes;
	int Ret;

        icon=ui_xpm;
	 
	XGetWindowAttributes(Disp,Root,&Attributes);		
	UI.attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);
	
	Ret = XpmCreatePixmapFromData(Disp, Root, icon, &UI.pixmap,
		      &UI.mask, &UI.attributes);
	if(Ret != XpmSuccess)
	{
		fprintf(stderr, "xtcd: not enough free color cells\n");
		exit(1);
	}
}

/****************************************************************************/
int FlushExpose(Window w)
{
	XEvent dummy;
	int i=0;
	
	while (XCheckTypedWindowEvent (Disp, w, Expose, &dummy))i++;
	return i;
}

/****************************************************************************/
void RedrawWindow(XpmIcon *Icon)
{		
	int x,y,res;
	char tmp[80];

	FlushExpose(Win);

	XCopyArea(Disp,UI.pixmap,Buffer,WinGC,
		0,0,UI.attributes.width, UI.attributes.height,0,0);
	
	if( isclicked )
	{
		XSetForeground( Disp, WinGC, GetColor("dimgray") );
		for( x=clickx; x < (clickx+clickw); x+=2 )
			for( y=clicky; y < (clicky+clickh); y+=2 )
				XDrawPoint( Disp, Buffer, WinGC, x,y );
	}
	
	XSetForeground( Disp, WinGC, GetColor("green") );
	XSetBackground( Disp, WinGC, GetColor("red") );
	XSetFillStyle(  Disp, WinGC, FillStippled );
	
	switch( cd->sc.cdsc_audiostatus )
	{
	case CDROM_AUDIO_INVALID:
		strcpy( tmp,"Audio-Incapable" );
	 	break;
	case CDROM_AUDIO_PLAY:
		sprintf( tmp,"Playing:      %2d/%d", cd->cur_t,cd->last_t );
		break;
	case CDROM_AUDIO_PAUSED:
		strcpy( tmp,"Paused" );
		break;
	case CDROM_AUDIO_COMPLETED:
		strcpy( tmp,"Complete" );
		break;
	case CDROM_AUDIO_ERROR:
		strcpy( tmp,"Error" );
		break;
	case CDROM_AUDIO_NO_STATUS:
		strcpy( tmp,"Stopped" );
		break;
	default:
		strcpy( tmp,"" );
	}	

	XDrawString( Disp, Buffer, WinGC, 162,80, tmp, strlen(tmp) );
	sprintf( tmp, "Track Time:   %2d:%02d", cd->t_min, cd->t_sec );
	XDrawString( Disp, Buffer, WinGC, 162,102, tmp, strlen(tmp) );
	sprintf( tmp, "CD Time:      %2d:%02d", cd->cd_min, cd->cd_sec );
	XDrawString( Disp, Buffer, WinGC, 162,114, tmp, strlen(tmp) );

	sprintf( tmp, "Track:    %s", cd->trk[cd->cur_t].name );
	XDrawString( Disp, Buffer, WinGC, 12, 22, tmp, strlen(tmp) );	
	sprintf( tmp, "Title:   %s", cd->dtitle );
	XDrawString( Disp, Buffer, WinGC, 12, 34, tmp, strlen(tmp) );	
		
	if( ismixer ) DrawMixer(Buffer);

	res = XCopyArea(Disp,Buffer,Win,WinGC,0,0,300,
		                            150, 0,0 );
	needsredraw=FALSE;
}

void DrawMixer( Pixmap Buffer )
{
	mixer_setting_str mix;
	int r,l;
	
	mix.device = SOUND_MIXER_VOLUME;
	if( mix_get_setting( &mixer, &mix ) != 0 )
	{
		return;
	}
	
	r = (mix.right*1.28)+159;
	l = (mix.left*1.28)+159;
	
	XSetForeground( Disp, WinGC, GetColor("red") );
	XDrawLine( Disp, Buffer, WinGC, 159, 133, r, 133 );
	XDrawLine( Disp, Buffer, WinGC, 159, 134, r, 134 );

	XSetForeground( Disp, WinGC, GetColor("yellow") );
	XDrawLine( Disp, Buffer, WinGC, 159, 135, l, 135 );
	XDrawLine( Disp, Buffer, WinGC, 159, 136, l, 136 );
}
/****************************************************************************/
Pixel GetColor(char *ColorName)
{
	XColor Color;
	XWindowAttributes Attributes;
	
	XGetWindowAttributes(Disp,Root,&Attributes);
	Color.pixel = 0;
	
	if (!XParseColor (Disp, Attributes.colormap, ColorName, &Color)) 
		fprintf(stderr,"xtcd: can't parse %s\n", ColorName);
	else if(!XAllocColor (Disp, Attributes.colormap, &Color)) 
		fprintf(stderr,"xtcd: can't allocate %s\n", ColorName);       
	
	return Color.pixel;
}

int IsInside( int mx, int my, int tx, int ty, int tw, int th )
{
	if( mx < tx )
		return FALSE;
	if( mx > (tx+tw) )
		return FALSE;
	if( my < ty )
		return FALSE;
	if( my > (ty+th) )
		return FALSE;
	
	return TRUE;
}

void prev_track(int x, int y, int type)
{
	isclicked=TRUE;
	clickw = clickh = 32;
	clickx = 5; clicky = 73;
	RedrawWindow(&UI);
	isclicked=FALSE;

	needsredraw=TRUE;
	if( cd->isplayable )
		tcd_playtracks( cd, --cd->cur_t, cd->last_t );
	if( cd->err )
		perror( "tcd_playtracks" );
}
void next_track(int x, int y, int type)
{
	isclicked=TRUE;
	clickw = clickh = 32;
	clickx = 110; clicky = 73;
	RedrawWindow(&UI);
	isclicked=FALSE;

	needsredraw=TRUE;
	if( cd->isplayable )
		tcd_playtracks( cd, ++cd->cur_t, cd->last_t );
	if( cd->err )
		perror( "tcd_playtracks" );
}
void fast_forward(int x, int y, int type)
{
	if( type == PUSHED )
	{
		isclicked=TRUE;
		clickw = clickh = 32;
		clickx = 75; clicky = 73;
		return;
	}
	else {
		isclicked=FALSE;
	}
	fprintf( stderr, "Not yet implemented.\n" );
	needsredraw=TRUE;
}
void x_rewind(int x, int y, int type)
{
	if( type == PUSHED )
	{
		isclicked=TRUE;
		clickw = clickh = 32;
		clickx = 40; clicky = 73;
		return;
	}
	else {
		isclicked=FALSE;
	}
	fprintf( stderr, "Not yet implemented.\n" );
	needsredraw=TRUE;
}
void stop(int x, int y, int type)
{
	isclicked=TRUE;
	clickw = clickh = 32;
	clickx = 5; clicky = 110;
	RedrawWindow(&UI);
	isclicked=FALSE;

	needsredraw=TRUE;
	tcd_stopcd(cd);
	if( cd->err )
		perror( "tcd_stopcd" );
}
void play(int x, int y, int type)
{

	isclicked=TRUE;
	clickw = clickh = 32;
	clickx = 40; clicky = 110;
	RedrawWindow(&UI);
	isclicked=FALSE;

	if( cd->sc.cdsc_audiostatus == CDROM_AUDIO_PAUSED )
	{
		tcd_pausecd(cd);
		if( cd->err )
			perror( "tcd_pausecd" );
		return;
	}
	needsredraw=TRUE;
	if( cd->isplayable ) tcd_playtracks( cd, cd->first_t, cd->last_t ); 
	if( cd->err )
	{
		perror( "tcd_playtracks" );
		return;
	}
}
void x_pause( int x, int y, int type) 
{
	isclicked=TRUE;
	clickw = clickh = 32;
	clickx = 75; clicky = 110;
	RedrawWindow(&UI);
	isclicked=FALSE;
	
	needsredraw=TRUE;
	tcd_pausecd(cd);
	if( cd->err )
	{
		perror( "tcd_pausecd" );
		return;
	}
}
void 	quit( int x, int y, int type)
{
	if( type == PUSHED )
	{
		isclicked = TRUE;
		clickx = 110; clicky = 130;
		clickw = 30; clickh = 12;
		return;
	}
	else {
		isclicked=FALSE;
	}
	Done();
	exit(0);
}
void	eject( int x, int y, int type)
{
	isclicked = TRUE;
	clickx = 110; clicky = 110;
	clickw = 30; clickh = 12;
	RedrawWindow(&UI);
	isclicked=FALSE;

	needsredraw=TRUE;
	tcd_ejectcd(cd);
	if( cd->err )
	{
		perror( "tcd_ejectcd" );
		return;
	}
}

void	setmixer( int x, int y, int button )
{
	mixer_setting_str old,new;

	old.device = SOUND_MIXER_VOLUME;
	if( mix_get_setting( &mixer, &old ) < 0 )
	{
		perror( "mix_get_setting" );
		return;
	}
	switch( button )
	{
		/* Left button */
		case Button1:
			new.right = old.right;
			new.left = (x-159)*0.78;
			break;
		/* middle, **FIXME**, this may be the right button!! */
		case Button2:
			new.right = (x-159)*0.78;
			new.left = old.left;
			break;
		case Button3:
			new.right = (x-159)*0.78;
			new.left = (x-159)*0.78;
			break;
		default:
			new.right = old.right;
			new.left = old.left;
	}
	new.device = SOUND_MIXER_VOLUME;
	if( mix_set_setting( &mixer, &new ) < 0 )
		perror( "mix_set_setting" );
	return;
}

void move_or_focus(int x, int y)
{
	XEvent report;
	int i=0;
	Cursor hand_cursor;
	
	hand_cursor = XCreateFontCursor(Disp, XC_hand2);
	         
	
	XGrabPointer(Disp, Win, False, (ButtonPressMask | ButtonReleaseMask | 
		PointerMotionMask), GrabModeAsync, GrabModeAsync, None, hand_cursor,
		CurrentTime);

	while(!i)
	{
		XNextEvent(Disp, &report);
		switch(report.type)
		{
			case ButtonRelease:
				XUngrabPointer(Disp, CurrentTime);
				i=1;
				break;
			case MotionNotify:
				XMoveWindow(Disp, Win,
					report.xmotion.x_root-x, report.xmotion.y_root-y);
				
				break;
		}	
		XSetInputFocus(Disp, Win, RevertToPointerRoot, CurrentTime);
		XRaiseWindow(Disp, Win);
		XFlush(Disp);
	}

}
