package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details
 */

import java.awt.*;

public class AboutJcd extends Dialog {

  static final String LIB_DIR = JcdProps.get("jcd.lib", "/usr/local/lib/jcd") + "/";

  public final String text[] =
  { JcdProps.get("jcd.version", 
		 JcdProps.JCD_VERSION) + " - Java Audio CD Player",
    "Jcd was written by Michael Hamilton (michael@actrix.gen.nz).",
    "http://www.actrix.gen.nz/users/michael",
    "Copyright (c) 1996 Michael Hamilton.\n",
    "All rights reserved.  See the README for full details.",
    "",
    "Jcd uses the Xmcd cddb database format and protocols.",
    "courtesy of Ti Kan and Steve Scherf",
    "http://sunsite.unc.edu/~cddb/xmcd"
  };

  protected Button dismiss;
  protected TextArea message;
  protected FancyButton linux;
  protected Label linuxCredits;
  protected Form form;

  public AboutJcd(Frame parent)
  {
    super(parent, "About Jcd", false);

    form = new Form();
    setLayout(new GridBagLayout());
    
    linux = new FancyButton(Toolkit.getDefaultToolkit().getImage(LIB_DIR + 
								 "images/penguin.gif"));
    form.addCenter(linux);

    for (int i = 0; i < text.length; i++) {
      Label line = new Label(text[i]);
      line.setFont(new Font("Helvetica", Font.PLAIN, 
			    18 - 2 * ((i < 3) ? i : 3)));
      form.addCenter(line);
    } 
    dismiss = new Button("Dismiss");
    form.addCenter(dismiss);
    add(form);
    pack();
    show();
  }

  public void dismiss()
  {
    hide();
    dispose();
  }

  public boolean action(Event e, Object arg)
  {
    if (e.target == linux) {
      if (linuxCredits == null) {
	linuxCredits = 
	  new Label("Primary Development Platform: Caldera OpenLinux 2.3, JDK 1.2.2");
	form.addCenter(linuxCredits);
	pack();
      }
    }
    else if (e.target == dismiss) {
      dismiss();
      return true;
    }
    return false;
  }

  public boolean handleEvent(Event e) 
  {
    if (e.id == Event.WINDOW_DESTROY && e.target == this) {
      dismiss();
    }

    return super.handleEvent(e);
  }
}

