package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details.
 */

import java.io.*;
import java.util.*;
import java.awt.*;

import Jcd.SmartDrive;
import Jcd.Monitor;
import Jcd.Display;


class Controls extends Form implements Observer {

  //
  // Standard CD player control panel with the usual buttons for
  // play, stop, eject, ...
  //

  Display display;

  static final String LIB_DIR = JcdProps.get("jcd.lib", "/usr/local/lib/jcd") + "/";

  static final String PLAY_GIF_FILE[] = {
    LIB_DIR + "/images/play.gif",
    LIB_DIR + "/images/play-active.gif"
  };

  static final String PAUSE_GIF_FILE[] = {
    LIB_DIR + "/images/pause.gif",
    LIB_DIR + "/images/pause-active.gif"
  };

  static final String STOP_GIF_FILE  = LIB_DIR + "/images/stop.gif";
  static final String NEXT_GIF_FILE  = LIB_DIR + "/images/next.gif";
  static final String PREV_GIF_FILE  = LIB_DIR + "/images/prev.gif";
  static final String EJECT_GIF_FILE = LIB_DIR + "/images/eject.gif";

  protected SubPanel driveControls; 

  protected FancyButton play =
  new FancyButton(Toolkit.getDefaultToolkit().getImage(PLAY_GIF_FILE[0]),
		  Toolkit.getDefaultToolkit().getImage(PLAY_GIF_FILE[1]));

  protected FancyButton pause =
  new FancyButton(Toolkit.getDefaultToolkit().getImage(PAUSE_GIF_FILE[0]),
		  Toolkit.getDefaultToolkit().getImage(PAUSE_GIF_FILE[1]));

  protected FancyButton stop = 
  new FancyButton(Toolkit.getDefaultToolkit().getImage(STOP_GIF_FILE));

  protected FancyButton next = 
  new FancyButton(Toolkit.getDefaultToolkit().getImage(NEXT_GIF_FILE));

  protected FancyButton prev = 
  new FancyButton(Toolkit.getDefaultToolkit().getImage(PREV_GIF_FILE));

  protected FancyButton eject = 
  new FancyButton(Toolkit.getDefaultToolkit().getImage(EJECT_GIF_FILE));

  
  protected SmartDrive cdPlayer;	// Saves de-ref'ing cdMonitor all the time.

  public Controls(SmartDrive drive, Display disp) 
  {
    cdPlayer = drive;
    display = disp;

    driveControls = new SubPanel();
    driveControls.setLayout(new GridLayout(2, 3, 2, 2));

   
    driveControls.add(play);
    driveControls.add(stop);
    driveControls.add(pause);
    driveControls.add(prev);
    driveControls.add(next);
    driveControls.add(eject);

    addCenter(driveControls);
  
    cdPlayer.monitor.addObserver(this);
  }
  
  public void update(Observable monitor, Object arg)
  {
    showStatus(((Monitor) monitor).status);
  }

  synchronized void showStatus(int status)
  {
    if (status == Drive.STATUS_PAUSED) {
      play.deactivate();
      pause.activate();
    }
    else if (status == Drive.STATUS_PLAY) {
      pause.deactivate();
      play.activate();
    }
    else {
      pause.deactivate();
      play.deactivate();
    }
  }

  public boolean action(Event e, Object arg)
  {
    int tmp_stat = cdPlayer.monitor.status;

    try {
				// This is awful - should subclass
				// each button with its own behaviour
				// - Java needs closures?
      if (e.target == play) {
	cdPlayer.startPlaying();
	tmp_stat = Drive.STATUS_PLAY;
      }
      else if (e.target == stop) {
	cdPlayer.stop();
      }
      else if (e.target == next) {
	cdPlayer.next();
	tmp_stat = Drive.STATUS_PLAY;
      }
      else if (e.target == prev) {
	cdPlayer.prev();
	tmp_stat = Drive.STATUS_PLAY;
      }
      else if (e.target == pause) {
	tmp_stat = cdPlayer.togglePause();
      }
      else if (e.target == eject) {
	cdPlayer.eject();
      }
      else {
	return false;
      }
    }
    catch (DriveException except) {
      System.out.println("Exception " + except);
    }

    showStatus(tmp_stat);	// Light up any buttons as appropriate.

    return true;
  }
}

