package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details
 */

import java.util.*;
import java.awt.*;
import Jcd.SmartDrive;
import Jcd.Monitor;
import Jcd.LEDfield;
import Jcd.CddbClient;

class Display extends Panel implements Observer {

  public static final int TRACK_ELAPSED   = 0;
  public static final int TRACK_REMAINING = 1;
  public static final int REMAINING       = 2;
  public static final int NUM_TIME_MODES  = 3;

  protected static final String TIME_LABEL[] = {"Track Time", 
						"Track Rem.",
						"Remaining"};

  public int timeMode = Display.TRACK_ELAPSED;

  // Independent status display thread.  
  // Updates itself once a second.

  protected LEDfield trackField       = new LEDfield("Track", 2);
  protected LEDfield indexField       = new LEDfield("Index", 2);
  protected LEDfield totalTracksField = new LEDfield("Tot. Tr.", 2);
  protected LEDfield timeField        = new LEDfield(TIME_LABEL[0], 4);

  protected SmartDrive cdPlayer;

  public Display(SmartDrive drive) 
  {
    setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));
    // setBackground(Color.black);

    timeField.setEditable(false);
    totalTracksField.setEditable(false);

    cdPlayer = drive;
    add(trackField);
    add(indexField);
    add(totalTracksField);
    add(timeField);

    cdPlayer.monitor.addObserver(this);
  }

  public void update(Observable o, Object arg) {
    Monitor monitor = (Monitor) o;
    if (monitor.status != Drive.STATUS_INVALID) {
      trackField.setText(Integer.toString(monitor.currentTrack));
      indexField.setText(Integer.toString(monitor.currentIndex));
      totalTracksField.setText(Integer.toString(cdPlayer.monitor.numberOfTracks));

      if (timeMode == Display.TRACK_ELAPSED) {
	timeField.setText(CddbEntry.timeToString(monitor.trackElapsed));
      }
      else if (timeMode == Display.TRACK_REMAINING
	       || (timeMode == Display.REMAINING && cdPlayer.singleMode)) {
	timeField.setText(CddbEntry.timeToString(
          cdPlayer.monitor.trackEndAddress[cdPlayer.monitor.currentTrack] 
          - cdPlayer.monitor.currentAddress));
      }
      else if (timeMode == Display.REMAINING) {
	timeField.setText(CddbEntry.timeToString(cdPlayer.remaining()));
      }
    }
  }
  
  public boolean handleEvent(Event e)
  {
    if (e.target == trackField
	&& e.id == Event.KEY_PRESS
	&& e.key == '\n') {
      try {
	cdPlayer.play(Integer.parseInt(trackField.getText()));
      }
      catch (NumberFormatException ex) {
      }
      catch (DriveException dx) {
	System.out.println("Exception" + dx);
      }
    }
    else if (e.target == indexField 
	     && e.id == Event.KEY_PRESS
	     && e.key == '\n') {
      try {
	cdPlayer.play(Integer.parseInt(trackField.getText()),
		       Integer.parseInt(indexField.getText()));
      }
      catch (NumberFormatException ex) {
      }
      catch (DriveException dx) {
	System.out.println("Exception" + dx);
      }
    }
    else {
      return super.handleEvent(e); // Invoke default handler
    }
    return true;
  }

  public void setTimeMode(int mode)
  {
    timeMode = mode;
    timeField.setLabel(TIME_LABEL[mode]);
  }

}

