package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details
 */



class Drive {

  public static final int FRAMES_PER_SECOND = 75;

				// Lead out is always track 0xAA 
				// regardless of the actual number of
				// tracks.
  public static final int LEAD_OUT = 0xAA; 

				// Status values returned by the
				// status() method. Currently these
				// correspond to those values defined
				// in <linux/cdrom.h>.  Must match
				// with those in DriveLib.c
  public static final int STATUS_INVALID   = 0x00;
  public static final int STATUS_PLAY      = 0x11;
  public static final int STATUS_PAUSED    = 0x12;
  public static final int STATUS_COMPLETED = 0x13;
  public static final int STATUS_ERROR     = 0x14;
  public static final int STATUS_NOSTATUS  = 0x15;

				// Device flag values - bit string.
  public static final int FLAG_NONE      = 0x00;
  public static final int FLAG_STOP_PLAY = 0x01; // Needs stop() before play()

				// For now I'll keep these private.
				// Would expand this to include more
				// status info if we ever want to support
				// multiple CD players.

  String device_name  = "/dev/cdrom";
  int    device_flags = FLAG_NONE;

  int fd = -1;			// File descriptor.
  
  int audio_status = Drive.STATUS_INVALID;

  int number_of_tracks = 0;    
  int current_track = 0;	     
  int current_index = 0;	     
  int current_address = 0;	// expressed as number of frames

  public Drive()
  {
    this("/dev/cdrom", "Jcd_Drive.so", 0);
  }

  public Drive(String dev, String module, int flags) 
  {
    System.load(module); 
    device_name = dev;
    device_flags = flags;
    try {
      initDrive();	// Force an attempt to obtain the device.
    }
    catch (DriveException de) {
    }
  }

  native void initDrive() throws DriveException;

				// Origin 1.
  public native synchronized int currentTrack()   throws DriveException;

				// Must call currentTrack() before calling
				// currentIndex().
  public native synchronized int currentIndex()   throws DriveException; 

  public native synchronized int numberOfTracks() throws DriveException;

				// Addresses can vary for the same CD
				// produced in different countries.
				// Expressed in frame units - 75
				// frames per second.
  public native synchronized int currentAddress()    throws DriveException;
  public native synchronized int cdEndAddress()      throws DriveException;
  public native synchronized int trackAddress(int n) throws DriveException;
  public native synchronized int trackLength(int n)  throws DriveException;

  public int trackAddress() throws DriveException
  {
    return trackAddress(currentTrack());
  }

  public int trackEndAddress(int n) throws DriveException
  {
    return n >= numberOfTracks() ? cdEndAddress() : trackAddress(n + 1) - 1;
  }

  public int trackEndAddress() throws DriveException
  {
    return trackEndAddress(currentTrack());
  }

  public int trackLength() throws DriveException
  {
    return trackLength(currentTrack());
  }

				// xjcd cddb address - 
				// see http://sunsite.unc.edu~/cddb/xjcd/
  public native synchronized String cddbID() throws DriveException;

				// CD's product code (might be different
				// for the same CD produced in different
				// countries?
  public native synchronized String productCode() throws DriveException;

				// One of the values defined above.
				// Active query of drive.  May result
				// in drive closing.
  public native synchronized int status() throws DriveException;

				// Play from start to end inclusive.
  public native synchronized void play(int startTrack, 
				       int startIndex, 
				       int endTrack,
				       int endIndex) throws DriveException;

  public native synchronized void stop()   throws DriveException;
  public native synchronized void pause()  throws DriveException;
  public native synchronized void resume() throws DriveException;
  public native synchronized void eject()  throws DriveException;

  public native synchronized void setVolume(int volume) throws DriveException;

  public native synchronized int volume() throws DriveException;

  public void play(int n) throws DriveException
  {				// Play from n to the end.
    play(n, 1, numberOfTracks(), 0);
  }

  public void play(int n, int i) throws DriveException
  {				// Play from n,i to the end.
    play(n, i, numberOfTracks(), 0);
  }

  public void single(int n) throws DriveException
  {				// Play a single track
    play(n, 1, n, 0);
  }

}

