package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details
 */

import java.awt.*;
import java.awt.image.*;

public class FancyButton extends Panel {

				// Colors for the button bevel.
  static private final Color gray90 = new Color (210, 210, 210);
  static private final Color gray80 = new Color (204, 204, 204);
  static private final Color gray30 = new Color (75, 75, 75);

  Image normalImage = null;	// Show when button isn't being pressed.
  Image activeImage = null;	// Show when button isn't being pressed but
				// status is active.

  boolean isPressed = false;
  boolean isActive  = false;

  int width = 0, height = 0;

				// Need to know w and h before 
				// the image gets drawn.
  public FancyButton(Image normal, 
		     Image active) {

				// Use this to wait for the images to
				// be loaded.
    MediaTracker mt = new MediaTracker(this);

    mt.addImage(normal, 1);
    if (active != null) {
      mt.addImage(active, 2);
    }

    try {
				// Wait for the images to be loaded so
				// that we can find out their
				// dimensions.
      mt.waitForAll(); 
    }
    catch (InterruptedException e) {
				// Shouldn't happen?
      System.out.println("Image loading exception!");
    }
				// Should now be able to get the dimensions.
    width = normal.getWidth(this);
    height = normal.getHeight(this);

    setLayout(new FlowLayout(FlowLayout.LEFT, width/2, height/2));

    normalImage = normal;
    activeImage = active;

    isPressed = false;

    repaint();
  }

  public FancyButton(Image normal) {
    this(normal, null);
  }

  public void activate() {
    if (isShowing() && activeImage != null && !isActive) {
      isActive = true;
      paintme(getGraphics());
    }
  }

  public void deactivate() {
    if (isShowing() && activeImage != null && isActive) {
      isActive = false;
      paintme(getGraphics());
    }
  }

  public void update(Graphics g)
  {
    paintme(g);
  }

  public void paint(Graphics g) {
    paintme(g);
  }

  public void paintme(Graphics g) {

    Image image = normalImage;
    
    resize(width, height);

    if (activeImage != null && isActive) {
      image = activeImage;
    }

    g.drawImage(image, 0, 0, this);
    makeBevel(g, 0, 0, width, height);

  }

  public boolean imageUpdate(Image img, int flags,
			     int x, int y, int width, int height)
  {
    if ((flags & ERROR) != 0) {
    } else {
      if ((flags & ALLBITS) != 0) {
	repaint();
      } else {
      }
    }
    return ( (flags & ALLBITS) == 0); // Don't do anything till we're loaded
  }

  public boolean mouseEnter(Event evt, int x, int y) 
  {
    // Make my string
    repaint();
    return true;
  }

  public boolean mouseExit(Event evt, int x, int y) 
  {
    // Clear
    isPressed = false;

    repaint();
    return true;
  }

  public boolean mouseDown(Event evt, int x, int y) 
  {
    isPressed = true;
    repaint();
    return true;
  }

  public boolean mouseUp(Event evt, int x, int y)
  {
    isPressed = false;
    repaint();
    if (locate(x, y) == this) {	// Is the mouse still over the button?
      ((Component) getParent()).action(evt, this);
    }
    return true;
  }

  Color makeBevel(Graphics g, int xpos, int ypos, 
		   int xsize, int ysize) {
				// Based on code from NCSA javigator.

    Color saveColor, returnColor;

    saveColor = g.getColor();
    returnColor = saveColor;

    if (isPressed) {
      g.setColor(gray30);
      g.drawLine(xpos, ypos, xpos+xsize-1,ypos);
      g.drawLine(xpos, ypos+1, xpos+xsize-2, ypos+1);
      g.drawLine(xpos, ypos, xpos, ypos+ysize-1);
      g.drawLine(xpos+1, ypos+1, xpos+1, ypos+ysize-1);
      g.drawLine(xpos+2, ypos+1, xpos+2, ypos+ysize-2);
      
      g.setColor(gray90);
      g.drawLine(xpos+3, ypos+ysize-2, xpos+xsize-1, ypos+ysize-2);
      g.drawLine(xpos+2, ypos+ysize-1, xpos+xsize-1, ypos+ysize-1);
      g.drawLine(xpos+xsize-1, ypos+1, xpos+xsize-1, ypos+ysize-1);
      g.drawLine(xpos+xsize-2, ypos+2, xpos+xsize-2, ypos+ysize-1);
    } else {
      g.setColor(gray90);
      g.drawLine(xpos, ypos, xpos+xsize-1,ypos);
      g.drawLine(xpos, ypos+1, xpos+xsize-2, ypos+1);
      g.drawLine(xpos, ypos, xpos, ypos+ysize-1);
      g.drawLine(xpos+1, ypos+1, xpos+1, ypos+ysize-1);
      g.drawLine(xpos+2, ypos+1, xpos+2, ypos+ysize-2);
      
      g.setColor(gray30);
      g.drawLine(xpos+1, ypos+ysize-1, xpos+xsize-1, ypos+ysize-1);
      g.drawLine(xpos+2, ypos+ysize-2, xpos+xsize-1, ypos+ysize-2);
      g.drawLine(xpos+xsize-1, ypos+1, xpos+xsize-1, ypos+ysize-1);
      g.drawLine(xpos+xsize-2, ypos+2, xpos+xsize-2, ypos+ysize-1);
    } 
    g.setColor(saveColor);
    return(returnColor);
  }


}

