package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details.
 */

import java.awt.*;

public class Form extends SubPanel {

  public GridBagLayout layout;
  public Form form;

  protected Insets formInsets = new Insets(1,1,1,1);

  public Form() 
  {
    layout = new GridBagLayout();
    setLayout(layout);
  }

  public Component addAcross(Component comp)
  {
    return addAcross(comp, GridBagConstraints.HORIZONTAL);
  }

  public Component addAcross(Component comp, int fill)
  {
    GridBagConstraints c = new GridBagConstraints();
    c.gridx = GridBagConstraints.RELATIVE;
    c.gridy = 0;
    c.anchor = GridBagConstraints.EAST;
    c.fill = fill;
    c.insets = formInsets;
    layout.setConstraints(comp, c);
    return super.add(comp);
  }

  public Component addXY(Component comp, int x, int y)
  {
    return addXY(comp, x, y, 1, 1, null);
  }

  public Component addXY(Component comp, int x, int y, int w, int h)
  {
    return addXY(comp, x, y, w, h, null);
  }

  public Component addXY(Component comp, int x, int y, int w, int h, 
			 Insets insets)
  {
    GridBagConstraints c = new GridBagConstraints();
    c.gridx = x;
    c.gridy = y;
    c.gridwidth = w;
    c.gridheight = h;
    c.anchor = GridBagConstraints.WEST;
    c.insets = insets == null ? formInsets : insets;
    layout.setConstraints(comp, c);
    return super.add(comp);
  }

  public Component addDown(Component comp)
  {
    return addDown(comp, GridBagConstraints.HORIZONTAL, null);
  }

  public Component addDown(Component comp, int fill)
  {
    return addDown(comp, fill, null);
  }

  public Component addDown(Component comp, Insets insets)
  {
    return addDown(comp, GridBagConstraints.HORIZONTAL, insets);
  }

  public Component addDown(Component comp, int fill, Insets insets)
  {
    GridBagConstraints c = new GridBagConstraints();
    c.gridx = 0;
    c.gridy = GridBagConstraints.RELATIVE;
    c.anchor = GridBagConstraints.WEST;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.fill = fill;
    c.insets = insets == null ? formInsets : insets;
    layout.setConstraints(comp, c);
    return super.add(comp);
  }

  public Component addCenter(Component comp)
  {
    return addCenter(comp, GridBagConstraints.NONE);
  }

  public Component addCenter(Component comp, int fill)
  {
    return addCenter(comp, fill, formInsets);   
  }

  public Component addCenter(Component comp, int fill, Insets insets)
  {
    GridBagConstraints c = new GridBagConstraints();
    c.gridx = 0;
    c.gridy = GridBagConstraints.RELATIVE;
    c.anchor = GridBagConstraints.CENTER;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.fill = fill;
    c.insets = insets;
    layout.setConstraints(comp, c);
    return super.add(comp);
  }

  public Component add(Component comp, int x, int y, int fill)
  {
    GridBagConstraints c = new GridBagConstraints();
    c.gridx = x;
    c.gridy = y;
    c.anchor = GridBagConstraints.WEST;
    c.fill = fill;
    c.insets = formInsets;
    layout.setConstraints(comp, c);
    return super.add(comp);
  }
}
