package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details
 */

import java.io.*;
import java.util.*;


class JcdProps {

  static final String JCD_VERSION = "Jcd 1.2";

  static final String RCFILE = System.getProperty("user.home") + File.separator + ".jcdrc";

  static Properties properties;

  static String get(String propName, String defaultValue)
  {
    if (JcdProps.properties == null) {
      JcdProps.init();
    }
    return JcdProps.properties.getProperty(propName, defaultValue).trim();
  }

  static int getInt(String propName, int defaultValue)
  {
    if (JcdProps.properties == null) {
      JcdProps.init();
    }
    String pval = JcdProps.properties.getProperty(propName);
    if (pval != null) {
      return Integer.parseInt(pval.trim());
    }
    return defaultValue;
  }

  static boolean getBoolean(String propName, boolean defaultValue)
  {
    if (JcdProps.properties == null) {
      JcdProps.init();
    }
    String pval = JcdProps.properties.getProperty(propName);
    if (pval != null) {
      String token = pval.trim().toLowerCase();
      return 
	token.compareTo("true") == 0 
	|| token.compareTo("yes") == 0 
	|| token.compareTo("1") == 0;
    }
    return defaultValue;
  }

  static void init()
  {
    JcdProps.properties = new Properties();
    try {
      JcdProps.properties.load(new FileInputStream(RCFILE));
    }
    catch (IOException no_rcfile) {
      System.out.println("Failed to load properties from " + RCFILE);
      // forget it.
    }
  }

}
