package Jcd;

/**
  Jcd - Java CD Audio Player
  Copyright (c) 1996.   Michael Hamilton (michael@actrix.gen.nz).
  All rights reserved.  See the README for full details
 */

import java.io.*;
import java.util.*;
import java.awt.*;

// Simuates a Light Emitting Diode style display.

class LEDfield extends Form {	

				// Shouldn't really make this stuff constant,
				// should be under user control.

  public  static final Color  LIGHTBLUE = new Color(98, 242, 250);
  public  static final int    FONTSIZE  = 14;

  private static final String FONTNAME  = "Helvetica";
  private static final int    LABELSIZE =  8;
  private static final Font   LABELFONT = new Font(FONTNAME, Font.PLAIN, LABELSIZE);

  public Label label;
  public Choice choice;
  public TextField field;

  protected String prevText = "";  // Save the text value set by setText().
				   // So we can tell whether to update (and
				   // not update if the user is editing).
  protected Font fieldfont;

  LEDfield(String labelText, int len)
  {
    this(labelText, len, FONTSIZE, LIGHTBLUE);
  }

  LEDfield(int len, int fontSize)
  {
    this(null, len, fontSize, LIGHTBLUE);
  }

  LEDfield(String labelText, int len, int fontSize)
  {
    this(labelText, len, fontSize, LIGHTBLUE);
  }

  LEDfield(String labelText, int len, Color color)
  {
    this(labelText, len, FONTSIZE, color);
  }

  LEDfield(String labelText, int len, int fontSize, Color color)
  {
    field = new TextField(len);
    field.setForeground(color);
    field.setBackground(Color.black);
    field.setFont(new Font(FONTNAME, Font.PLAIN, fontSize));
    addDown(field);
    if (labelText != null) {
      label = new Label(labelText);
      label.setFont(LEDfield.LABELFONT);
      addDown(label);
    }
  }

  public void disable()
  {
    field.disable();
  }

  public void enable()
  {
    field.enable();
  }

  public String getText() 
  {
    return field.getText();
  }

  public boolean handleEvent(Event e)
  {
    if (e.target == field && e.id == Event.KEY_PRESS && e.key == '\n') {
      Event e2 = new Event(this, e.when, e.id, e.x, e.y, e.key, e.modifiers,
			   e.arg);
      deliverEvent(e2);		// Make it look like LEDfield has a return
				// key event.
      return true;		// This event has been handled.
    }
    return super.handleEvent(e); // Pass on other events for normal handling.
  }

  public boolean lostFocus(Event e, Object what) 
  {
    field.setText(prevText);	// Restore - removes any text entered
				// without pressing return.
    return false;
  }

  public void select(int selStart, int selEnd)
  {
    field.select(selStart, selEnd);
  }

  public void selectAll()
  {
    field.selectAll();
  }

  public void setColor(Color color)
  {
    field.setForeground(color);
  }

  public void setEditable(boolean flag)
  {
    field.setEditable(flag);
  }

  public void setLabel(String text) 
  {
    label.setText(text);
  }

  public synchronized void setText(String text) 
  {
    // Only update if the text has really changed (prevents flashing).
    // Compare with the setText() previous value - this prevents any
    // text the user has changed from being updated.
    if (text.compareTo(prevText) != 0) {
      // System.out.println("p=<" + prevText + "><" + text + ">");
      prevText = new String(text);
      field.setText(text);
    }
  }

}
