package Jcd;

class MomentoLine {
  
  // Can't be a subsclass of StringBuffer, because StringBuffer is final.

  String tag = "";
  
  StringBuffer buffer = new StringBuffer(80);

  public MomentoLine(String tag) {
    this.tag = tag;
    buffer.append(tag);
    buffer.append("=");
  }

  public void append(String str) {
    buffer.append(str);
  }
  
  public void appendString(String str)	// Strings can be broken across lines
  {
    int sublen = 0;
    int len = 0;
    while (len < str.length()) {
      sublen = 80 - (tag.length() + 2); // 80 less tag len + space + newline
      if (str.length() < sublen) {
	sublen = str.length();
      }
      buffer.append(str.substring(len, sublen));
      len += sublen;
      if (len < str.length()) {
	buffer.append(CddbEntry.NEWLINE);
	buffer.append(tag);
	buffer.append("=");
      }
    }
  }

  public void appendToken(String str)	// Tokens must be keep in one piece over
				// line breaks
  {
    int sublen = 0;
    if (length() + str.length() > 78) {
      buffer.append(CddbEntry.NEWLINE);
      buffer.append(tag);
      buffer.append("=");
    }
    buffer.append(str);
  }

  public int length()
  {
    return buffer.length();
  }

  public String toString()
  {
    return buffer.toString();
  }
}
