package Jcd;

import java.io.*;

class TrackList extends java.util.Vector {

  static final boolean DEBUG = JcdProps.getBoolean("jcd.debug", false); 

  public int index = -1;

  protected Integer trackId[];	// Unique Object for each track

  protected boolean at_end = false;

  public synchronized void addTrack(int t) 
  {
    addElement(trackId[t - 1]);
  }    
  public boolean atEnd()
  {
    return at_end;
  }    
  public boolean atStart()
  {				// -1 == Haven't started playing the list yet.
    return index == -1;
  }    
  public synchronized void clear() 
  {
    index = -1;
    at_end = false;
    removeAllElements();
  }    
  public int currentTrack() 
  {
    if (index < 0) {
      return 0;
    }
    return ((Integer) elementAt(index)).intValue();
  }    

  /**
   * TrackList constructor comment.
   * @param initialCapacity int
   * @param capacityIncrement int
   */
  public TrackList(int initialCapacity, int capacityIncrement) {
    super(initialCapacity, capacityIncrement);
  }

  TrackList(int n)
  {
    trackId = new Integer[n];
    for (int i = 0; i < n; i++) {
      trackId[i] = new Integer(i + 1);
    }
  }    

  public void load(String fileName) throws IOException
  {
    
    BufferedReader br = 
	new BufferedReader(
                           new FileReader(
                                          new File(fileName)));
      
    String readersBuffer;
    
    while ( (readersBuffer = br.readLine()) != null) {
      addElement(new Integer(Integer.parseInt(readersBuffer)));
    }
  }

  public synchronized int nextTrack()
  {
    index++;
    if (size() > 0 && index >= size()) {
      index = size() - 1;
      at_end = true;
    }
    if (DEBUG) System.out.println("next track =" + index);
    return ((Integer) elementAt(index)).intValue();
  }    
  public synchronized int prevTrack()
  {
    index--;
    if (index <= 0) {
      index = 0;
    }
    return ((Integer) elementAt(index)).intValue();
  }    
  public synchronized void removeTrack(int t)
  {
    int pos = lastIndexOf(trackId[t - 1]);
    if (pos >= 0) {
      removeElement(trackId[t - 1]);
    }
    if (index > pos) {
      index--;
    }
    if (index >= size()) {
      index = size() - 1;
      at_end = true;
    }
  }    
  public synchronized void reset() 
  {
    at_end = false;
    index = -1;
  }    

  public void save(String fileName) throws IOException
  {
    ProgramFile pf = new ProgramFile(fileName);
    for (int i=0; i<size(); i++) {
      pf.println(elementAt(i));
    }
    pf.close();
  }

  public synchronized void skipTo(int track)
  {
    int last = index;
    if (size() > 0) {
      while (!atEnd()) {
	if (nextTrack() == track && !atEnd()) {
	  return;
	}
      }
      reset();
      while (!atEnd()) {
	if (nextTrack() == track) {
	  return;
	}
      }
      index = last;
    }
  }  
  
  /**
   * TrackList constructor comment.
   */
  public TrackList() {
    super();
  }
}
