#ifndef _CDSTATUS_H
#define _CDSTATUS_H

#define VERSION "0.94b"

#include <stdio.h>
#include <linux/cdrom.h>
#include <stdlib.h>

/* structure to hold all relevant program options */
typedef struct{
   int readtest;
   int waveout;
   int max_retries;
   int start;
   int stop;
   int reset;
   int read_chunk_size;
   int cddb;
   int format_on;
   char format[512];
   char outputdir[255];
   char basename[255];
   char drivename[255];
   int noMangle;
   int silent;
} cdstatus_args;

typedef struct{
   int min,sec,frame_local,frame_global,data;
} cd_toc_info;

typedef struct{
   char artist[256];
   char title[256];
} track_listing;

/* parses command line for arguments and takes appopriate action */
int handleArgs(int argc, char *argv[], cdstatus_args *);

/* Attempts to query further info from AUDIO and MIXED MODE cd's.  Takes
   arguments structure. */
int process_audio(const cdstatus_args *cdsargs);

/* performs drive reset.  takes args */
int doReset(const cdstatus_args *);

/* shows basic cd info + track info */
int basicInfo(const cdstatus_args *);

/* displays usage info */
void printHelp();

/* outputs wav header to file */
void writeWavHeader(int, FILE *);

int readTOC(int drive, cd_toc_info *, struct cdrom_tochdr *,int silent);

/* in cdstatus_cddb.c */
/* perform overall cddb query tasks */
void cddb_query(int tracks, const cd_toc_info* cdtocinfo, int noMangle);

/* calculate Disc ID for cddb database lookup */
unsigned int calcDiscId(int tracks, const cd_toc_info* cdtocinfo);

/* read and handle server response */
int hearken(int, void *);

int openOutputFile(const cdstatus_args *,int);

/* convert spaces to underscores and remove wierd characters from names so that they are
 * safe for filenames and directory names */
char * makePrettyString(char *);
#endif
