
#include "cddb.h"

int cddb_handle_data( const char *data, char** artist, char** dtitle, char* titles[], int* totaltracks, int include_artist, int include_dtitle, int include_tracknum, int convert_spaces )
{
	char * row, *mark;
	const char *tmp = data;
	int i, j, counter = 0, track, previoustrack = 100, ttcounter = 0;
	char* tempstr;

	if( strncmp( data, "# xmcd", 6 ) != 0 )
		return - 1;

	while( *tmp != 0 ){ /* check against end of string */

		/* get the row */
		i = strcspn( tmp, "\r\n" );
		while( tmp[ i ] == '\r' || tmp[ i ] == '\n' )
			i++;

		row = ( char* ) malloc( i + 1 );
		strncpy( row, tmp, i ); row[ i ] = 0;
		tmp += i;

		/* eval the row */
		if( strncmp( row, "TTITLE", 6 ) == 0 ){ /* Track TItle */
			/* get the track number before going on */
			/* skip the TTITLE */
			mark = row + 6;
			counter = 0;

			/* convert ascii -> int */
			while( *mark != '=' ){
				counter *= 10;
				counter += *mark - 0x30 ;
				mark++;
			}
			mark++; /* and skip the '=' */
			track = counter;

			if ( previoustrack != track )
				ttcounter++;

			/* create the filename. Append previous title if necessary */
			tempstr = malloc( MAX_TITLE_LENGTH );
			if ( previoustrack == track )
				strcpy( tempstr, titles[ track ] );
			else
				strcpy( tempstr, "" );

			/* put in the artist name */
			if ( include_artist && *artist != 0 )
			{
				strcat( tempstr, *artist );
				strcat( tempstr, " - " );
			}

			/* put in the disk title */
			if ( include_dtitle && *dtitle != 0 )
			{
				strcat( tempstr, *dtitle );
				strcat( tempstr, " - " );
			}

			/* put in the track number */
			if ( include_tracknum )
			{
				sprintf ( tempstr, "%s%02d - ", tempstr, track + 1 );
			}

			/* put in the track name */
			titles[ track ] = strcat ( tempstr, mark );

			strip_trailing_space( &titles[ track ] );
			strip_leading_space( &titles[ track ] );

			if ( convert_spaces )
				for( i = 0; titles[ track ][ i ]; i++ )
					if ( titles[ track ][ i ] == ' ' )
						titles[ track ][ i ] = '_';

			previoustrack = track;

#ifdef DEBUG
			printf( "Track %d: %s\n", track, titles[ track ] );
#endif
		}
		else if ( strncmp( row, "DTITLE", 6 ) == 0 ){ /* CD Title */
			i = strcspn( row, "=" ); i++; /* skip to the data */
			mark = row + i;

			j = strcspn( mark, "/" );
			( *artist ) = ( char* ) malloc( j + 1 );
			strncpy( ( *artist ), mark, j );
			( *artist )[ j ] = 0;
			( *dtitle ) = ( char* ) malloc ( strlen( mark ) - j );
			mark = mark + j + 1;
			strcpy( ( *dtitle ), mark );

			strip_trailing_space( artist );
			strip_leading_space( artist );
			strip_trailing_space( dtitle );
			strip_leading_space( dtitle );
#ifdef DEBUG
			printf( "Artist: %s\n", ( *artist ) );
			printf( "Dtitle: %s\n", ( *dtitle ) );
#endif;
		}

		/* ignore any other results */
		free( row );
	}

	*totaltracks = ttcounter;
	return 0;
}


unsigned long int cddb_disk_id( int length, int tracknum, long int offset[] )
{
	int track;
	long int result = 0, tmp;

	for( track = 0; track < tracknum; track++ ){
		tmp = offset[ track ] / 75;
		do{
			result += tmp % 10;
			tmp /= 10;
		}while( tmp != 0 );
	}

	return ( result % 0xff ) << 24 | ( length - ( offset[ 0 ] / 75 ) ) << 8 | tracknum;
}

int do_cddb( char** result, int tracknum, int duration, long int offset[], const char* server, int port )
{
	FILE * sock;
	int status, matches, i;
	char **category = NULL, **title = NULL, **alt_id = NULL;
	int proto = CDDBP;

	char *final_cat, *final_id, *cd_id;
	unsigned long int id;



	final_cat = ( char* ) malloc( 20 );
	final_id = ( char* ) malloc( 20 );
	cd_id = ( char* ) malloc( 20 );


	id = cddb_disk_id( duration, tracknum, offset );
	sprintf( cd_id, "%08lx", id );


	//strcpy(cd_id, "6c0db008");


	sock = socket_init( server, port );
	if ( !sock )
		return NO_CONNECT;

	/* connect to the cddb server */
	status = cddbp_signon( sock );
	switch ( status ) {
	case 200 : case 201 : break;	/* might want to differenciate when write() is supported
							   on the server side */
case 432 : case 433 : case 434 : fclose( sock ); return CONNECT_REFUSED;
			default : fclose( sock ); return SERVER_ERROR;
	}

	/* do the hello handshake */
	status = cddbp_handshake( sock, NAME, VERSION );
	switch ( status )
	{
	case 200 : case 402 : break;
		case 431 : fclose( sock ); return CONNECT_REFUSED;
			default : fclose( sock ); return SERVER_ERROR;
	}


	/* do a query */
	status = cddbp_query( sock, cd_id, tracknum, offset, duration, &matches,
                      	&category, &title, &alt_id );

	switch ( status )
	{
	case 200 : case 211 : break;
		case 202 : if( proto == CDDBP ) cddbp_signoff( sock ); return NOT_FOUND;
		case 403 : if( proto == CDDBP ) cddbp_signoff( sock ); return SERVER_ERROR;
			default : fclose( sock ); return SERVER_ERROR;
	}

	/* we don't care about multiple matches, just grab the first one */
	final_cat = strdup( category[ 0 ] );
	final_id = strdup( alt_id[ 0 ] );

	for ( i = 0; i < matches; i++ )
	{
		free( category[ i ] );
		free( title[ i ] );
		free( alt_id[ i ] );
	}
	free( category );
	free( title );
	free( alt_id );

	/* now finally grab the data for the disc id and category */
	status = cddbp_read( sock, final_cat, final_id, result );

	switch ( status ) {
		case 210 : break;
		case 401 : if( proto == CDDBP ) cddbp_signoff( sock ); return NOT_FOUND;
		case 403 : if( proto == CDDBP ) cddbp_signoff( sock ); return SERVER_ERROR;
			default : fclose( sock ); return SERVER_ERROR;
	}

	if( proto == CDDBP ) cddbp_signoff( sock );

	free( final_cat );
	free( final_id );

	return REMOTE_OK;

}

int cddb_main( _main_data *main_data )
{
	int err, i, totaltracks;

	char* result = NULL;
	char* artist = NULL;
	char* dtitle = NULL;
	char* titles[ MAX_NUM_TRACK ];

	int tracknum = main_data->num_tracks;
	int duration = main_data->total_length;
	long int offset[ MAX_NUM_TRACK ];

	main_window_handler( MW_UPDATE_STATUSBAR, "Contacting CDDB server...", NULL );
	while( gtk_events_pending() ) gtk_main_iteration();

	/* grab the track offsets from the main_data structure */
	for ( i = 0;i < tracknum;i++ )
		offset[ i ] = main_data->track[ i ].begin;

#ifdef TESTFILE
	/* for testing data handling functions. Does not connect to a cddb server
	   but instead reads data from file */
	FILE *datafile;
	result = ( char* ) malloc( 4096 );
	datafile = fopen( "testentry","r" );
	fread( result, 1, 4096, datafile );
	fclose( datafile );
	err = REMOTE_OK;
#else
	/* connect to the cddb server and grab the results */
	err = do_cddb( &result, tracknum, duration, offset, config.cddb_config.server, config.cddb_config.port );
#endif

	main_window_handler( MW_UPDATE_STATUSBAR, "Grabbing Completed...", NULL );
	while( gtk_events_pending() ) gtk_main_iteration();

	switch ( err )
	{
		case REMOTE_OK :
			/* successful lookup, now parse the returned data */
			cddb_handle_data( result, &artist, &dtitle, titles, &totaltracks, config.cddb_config.include_artist, config.cddb_config.include_dtitle, config.cddb_config.include_tracknum, config.cddb_config.convert_spaces );

			if (artist == 0)
				strcpy(main_data->disc_artist, "");
			else
				strcpy(main_data->disc_artist, artist);
			free(artist);
			
			if (dtitle == 0)
				strcpy(main_data->disc_title, "");
			else
				strcpy(main_data->disc_title, dtitle);
			free(dtitle);

			for( i = 0;i < totaltracks;i++ )
			{
#ifdef DEBUG
				printf( "%s\n", titles[ i ] );
#endif
				/* copy the data into the main_data structure */
				strcpy( main_data->track[ i ].wav_file, titles[ i ] );
				strcpy( main_data->track[ i ].mp3_file, titles[ i ] );
				free( titles[ i ] );
			}
			/* this is needed to update the display with the new data */
			select_frame_handler( SF_SYNC_SELECT_FRAME, 0, main_data );
			break;
		case NO_CONNECT :
			err_handler( CDDB_NO_CONNECT_ERR, NULL );
			break;
		case CONNECT_REFUSED :
			err_handler( CDDB_CONNECT_REFUSED_ERR, NULL );
			break;
		case SERVER_ERROR :
			err_handler( CDDB_SERVER_ERR, NULL );
			break;
		case NOT_FOUND :
			err_handler( CDDB_NOT_FOUND_ERR, NULL );
			break;
	}

	main_window_handler( MW_CLEAR_STATUSBAR, NULL, NULL );
	while( gtk_events_pending() ) gtk_main_iteration();

	return 0;
}
