
#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <math.h>

#include "misc_utils.h"
#include "err_dialog_handler.h"

#define VERSION                     "0.95-prelease1"

#ifndef TRUE
#define TRUE                     1
#endif
#ifndef FALSE
#define FALSE                    0
#endif

/* =====================================================
 * Constants
 * ===================================================*/

/* Global constants */
#define MAX_OPTIONS_LENGTH          300
#define MAX_SINGLE_OPTION_LENGTH    50

#define MAX_COMMAND_LENGTH          2048

#define MAX_ARGS                    50

#define MAX_FILE_PER_DIR            1024
#define MAX_FILE_NAME_LENGTH        512
#define MAX_FILE_PATH_LENGTH        512
#define MAX_NUM_TRACK               50
#define MAX_TITLE_LENGTH            1024
#define MAX_ARTIST_LENGTH            100

#define CD_SECTORS_PER_SEC          (float)75.018
#define CD_SECTORS_PER_FRAME        (float)1.959

#define CD                          0
#define WAV                         1
#define MP3                         2

#define NUM_PTYS                    128
/* =====================================================
 * Structures
 * ===================================================*/

/* Configuration Structure */
typedef struct {
		float wav_ratio;
		float mp3_ratio;
		char shell_for_execution[ MAX_COMMAND_LENGTH ];
		char wav_path[ MAX_FILE_PATH_LENGTH ];
		char mp3_path[ MAX_FILE_PATH_LENGTH ];
		char wav_file_name_format[ MAX_FILE_NAME_LENGTH ];
		char mp3_file_name_format[ MAX_FILE_NAME_LENGTH ];
		char prepend_char;
		int make_mp3_from_existing_wav;
		int ask_when_file_exists;
		int auto_append_extension;

		struct _ripper {
				char ripper[ MAX_COMMAND_LENGTH ];
				char plugin[ MAX_COMMAND_LENGTH ];
		} ripper;
		struct _encoder {
				char encoder[ MAX_COMMAND_LENGTH ];
				char plugin[ MAX_COMMAND_LENGTH ];
		} encoder;
		struct _cd_player {
				char play_command[ MAX_COMMAND_LENGTH ];
				char stop_command[ MAX_COMMAND_LENGTH ];
		} cd_player;
		struct _wav_player {
				char command[ MAX_COMMAND_LENGTH ];
		} wav_player;
		struct _mp3_player {
				char command[ MAX_COMMAND_LENGTH ];
		} mp3_player;
		struct _cddb_config {
				char server[ MAX_COMMAND_LENGTH ];
				int port;
				int convert_spaces;
				int include_artist;
				int include_dtitle;
				int include_tracknum;
				int make_directories;
		} cddb_config;
} _config;

/* Main data structure             */
/* All length is in cd sector unit */
typedef struct {
		int num_tracks;
		int total_length;
		char disc_artist[MAX_ARTIST_LENGTH];
		char disc_title[MAX_ARTIST_LENGTH];
		struct _track {
				unsigned begin;
				unsigned length;
				char wav_file[ MAX_FILE_PATH_LENGTH + MAX_FILE_NAME_LENGTH ];
				char mp3_file[ MAX_FILE_PATH_LENGTH + MAX_FILE_NAME_LENGTH ];
				int make_wav;
				int wav_exist;
				int make_mp3;
				int mp3_exist;
		} track[ MAX_NUM_TRACK ];
} _main_data;


extern _config config;
extern int where_now;
extern int errno;

#define SELECT_FRAME      0
#define STATUS_FRAME      1
#define CONFIG_WINDOW     2

#endif
