
#include "config_window_handler.h"

void cw_g_path_clicked( GtkWidget *widget, gpointer callback_data )
{
	GtkWidget * entry;
	char *temp;

	entry = ( GtkWidget * )callback_data;
	gtk_widget_set_sensitive( widget, FALSE );
	if ( ( temp = dir_window_handler( WIDGET_CREATE,
                              		gtk_entry_get_text( GTK_ENTRY( entry ) ) ) )
    		!= NULL )
		gtk_entry_set_text( GTK_ENTRY( entry ), temp );
	gtk_widget_set_sensitive( widget, TRUE );
}

int cw_general_handler( int ops, _main_data *main_data, GtkWidget *notebook )
{
	static GtkWidget * main_frame;
	static GtkWidget *wav_path_entry, *mp3_path_entry;
	static GtkWidget *wav_file_name_format_entry, *mp3_file_name_format_entry;
	static GtkWidget *prepend_char_entry;
	static GtkWidget *make_mp3_from_existing_wav_check_button;
	static GtkWidget *ask_when_file_exists_check_button;
	static GtkWidget *auto_append_extension_check_button;
	char buf[ 2 ];

	switch ( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * frame, *vbox, *table, *hbox, *label, *label2, *button;

				main_frame = gtk_frame_new( "General Configuration" );
				gtk_container_border_width( GTK_CONTAINER( main_frame ), 10 );

				vbox = gtk_vbox_new( FALSE, 0 );
				gtk_container_add( GTK_CONTAINER( main_frame ), vbox );

				/* Frame for wav */
				frame = gtk_frame_new( "Wav file" );
				gtk_container_border_width( GTK_CONTAINER( frame ), 2 );
				gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );

				table = gtk_table_new( 2, 2, FALSE );
				gtk_container_border_width( GTK_CONTAINER( table ), 3 );
				gtk_container_add( GTK_CONTAINER( frame ), table );

				label = gtk_label_new( "File name format: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
                  				0, GTK_EXPAND | GTK_FILL, 0, 0 );

				wav_file_name_format_entry
				= gtk_entry_new_with_max_length( MAX_FILE_NAME_LENGTH - 3 );
				gtk_entry_set_text( GTK_ENTRY( wav_file_name_format_entry ),
                    				config.wav_file_name_format );
				gtk_table_attach( GTK_TABLE( table ),
                  				wav_file_name_format_entry,
                  				1, 2, 0, 1,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				/* Create entry first to give its address as callback data */
				wav_path_entry
				= gtk_entry_new_with_max_length( MAX_FILE_PATH_LENGTH - 3 );
				button = gtk_button_new_with_label( "Target Directory: " );
				gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                    				GTK_SIGNAL_FUNC( cw_g_path_clicked ),
                    				wav_path_entry );
				gtk_table_attach( GTK_TABLE( table ), button, 0, 1, 1, 2,
                  				0, GTK_EXPAND | GTK_FILL, 2, 2 );

				gtk_entry_set_text( GTK_ENTRY( wav_path_entry ),
                    				config.wav_path );
				gtk_table_attach( GTK_TABLE( table ),
                  				wav_path_entry,
                  				1, 2, 1, 2,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				/* Frame for mp3 */
				frame = gtk_frame_new( "MP3 file" );
				gtk_container_border_width( GTK_CONTAINER( frame ), 2 );
				gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );

				table = gtk_table_new( 2, 2, FALSE );
				gtk_container_border_width( GTK_CONTAINER( table ), 3 );
				gtk_container_add( GTK_CONTAINER( frame ), table );

				label = gtk_label_new( "File name format: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
                  				0, GTK_EXPAND | GTK_FILL, 0, 0 );

				mp3_file_name_format_entry
				= gtk_entry_new_with_max_length( MAX_FILE_NAME_LENGTH - 3 );
				gtk_entry_set_text( GTK_ENTRY( mp3_file_name_format_entry ),
                    				config.mp3_file_name_format );
				gtk_table_attach( GTK_TABLE( table ),
                  				mp3_file_name_format_entry,
                  				1, 2, 0, 1,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				mp3_path_entry
				= gtk_entry_new_with_max_length( MAX_FILE_PATH_LENGTH - 3 );

				button = gtk_button_new_with_label( "Target Directory: " );
				gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                    				GTK_SIGNAL_FUNC( cw_g_path_clicked ),
                    				mp3_path_entry );
				gtk_table_attach( GTK_TABLE( table ), button, 0, 1, 1, 2,
                  				0, GTK_EXPAND | GTK_FILL, 2, 2 );

				gtk_entry_set_text( GTK_ENTRY( mp3_path_entry ),
                    				config.mp3_path );
				gtk_table_attach( GTK_TABLE( table ),
                  				mp3_path_entry,
                  				1, 2, 1, 2,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				/* Misc options */
				hbox = gtk_hbox_new( FALSE, 3 );
				gtk_container_border_width( GTK_CONTAINER( hbox ), 5 );
				gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 0 );

				label = gtk_label_new( "Prepend character : " );
				gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );

				buf[ 0 ] = config.prepend_char;
				buf[ 1 ] = '\0';
				prepend_char_entry = gtk_entry_new_with_max_length( 1 );
				gtk_widget_set_usize( prepend_char_entry, 16, 0 );
				gtk_entry_set_text( GTK_ENTRY( prepend_char_entry ),
                    				buf );
				gtk_box_pack_start( GTK_BOX( hbox ), prepend_char_entry, FALSE, FALSE, 0 );

				make_mp3_from_existing_wav_check_button
				= gtk_check_button_new_with_label( "Make Mp3 from existing Wav file" );
				gtk_toggle_button_set_state(
  				GTK_TOGGLE_BUTTON( make_mp3_from_existing_wav_check_button ),
  				config.make_mp3_from_existing_wav );
				gtk_box_pack_start( GTK_BOX( vbox ),
                    				make_mp3_from_existing_wav_check_button,
                    				TRUE, FALSE, 0 );

				ask_when_file_exists_check_button
				= gtk_check_button_new_with_label( "Ask user when specified file exists" );
				gtk_toggle_button_set_state(
  				GTK_TOGGLE_BUTTON( ask_when_file_exists_check_button ),
  				config.ask_when_file_exists );
				gtk_box_pack_start( GTK_BOX( vbox ),
                    				ask_when_file_exists_check_button,
                    				TRUE, FALSE, 0 );

				auto_append_extension_check_button
				= gtk_check_button_new_with_label( "Automatically append .wav or .mp3" );
				gtk_toggle_button_set_state(
  				GTK_TOGGLE_BUTTON( auto_append_extension_check_button ),
  				config.auto_append_extension );
				gtk_box_pack_start( GTK_BOX( vbox ),
                    				auto_append_extension_check_button,
                    				TRUE, FALSE, 0 );

				label = gtk_label_new( "General" );
				label2 = gtk_label_new( "General" );
				gtk_notebook_append_page_menu( GTK_NOTEBOOK( notebook ),
                               				main_frame, label, label2 );
				gtk_widget_show_all( main_frame );
				return 0;
			}

		case CW_OK :
			/* Wav */
			if ( strlen( gtk_entry_get_text(
           				GTK_ENTRY( wav_file_name_format_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text(
                 				GTK_ENTRY( wav_path_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text(
                 				GTK_ENTRY( mp3_file_name_format_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text(
                 				GTK_ENTRY( mp3_path_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text(
                 				GTK_ENTRY( prepend_char_entry ) ) ) == 0 )
			{
				err_handler( EMPTY_ENTRY_ERR, "You need to fill every entry in general page" );
				return - 1;
			}
			strcpy( config.wav_file_name_format,
        			gtk_entry_get_text( GTK_ENTRY( wav_file_name_format_entry ) ) );
			strcpy( config.wav_path,
        			gtk_entry_get_text( GTK_ENTRY( wav_path_entry ) ) );
			strcpy( config.mp3_file_name_format,
        			gtk_entry_get_text( GTK_ENTRY( mp3_file_name_format_entry ) ) );
			strcpy( config.mp3_path,
        			gtk_entry_get_text( GTK_ENTRY( mp3_path_entry ) ) );
			strcpy( buf,
        			gtk_entry_get_text( GTK_ENTRY( prepend_char_entry ) ) );
			config.prepend_char = buf[ 0 ];

			config.make_mp3_from_existing_wav =
  			GTK_TOGGLE_BUTTON( make_mp3_from_existing_wav_check_button )->active
  			? TRUE : FALSE;
			config.ask_when_file_exists =
  			GTK_TOGGLE_BUTTON( ask_when_file_exists_check_button )->active
  			? TRUE : FALSE;
			config.auto_append_extension =
  			GTK_TOGGLE_BUTTON( auto_append_extension_check_button )->active
  			? TRUE : FALSE;

			return 0;
	}
	/* Just to avoid warning */
	return 0;
}

int cw_wav_handler( int ops, _main_data *main_data, GtkWidget *notebook )
{
	static GtkWidget * main_frame;
	static GtkWidget *ripper_entry, *plugin_entry;

	switch ( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * vbox, *frame, *label, *label2, *table;

				main_frame = gtk_frame_new( "Wav Configuration" );
				gtk_container_border_width( GTK_CONTAINER( main_frame ), 10 );

				vbox = gtk_vbox_new( FALSE, 0 );
				gtk_container_border_width( GTK_CONTAINER( vbox ), 5 );
				gtk_container_add( GTK_CONTAINER( main_frame ), vbox );

				/* Frame for commands */
				frame = gtk_frame_new( "Commands" );
				gtk_container_border_width( GTK_CONTAINER( frame ), 2 );
				gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );

				table = gtk_table_new( 2, 2, FALSE );
				gtk_container_border_width( GTK_CONTAINER( table ), 3 );
				gtk_container_add( GTK_CONTAINER( frame ), table );

				// for ripper
				label = gtk_label_new( "Ripper: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
                  				0, GTK_EXPAND | GTK_FILL, 0, 0 );

				ripper_entry
				= gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH );
				gtk_entry_set_text( GTK_ENTRY( ripper_entry ),
                    				config.ripper.ripper );
				gtk_table_attach( GTK_TABLE( table ),
                  				ripper_entry,
                  				1, 2, 0, 1,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				// for plugin
				label = gtk_label_new( "Plugin: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2,
                  				0, GTK_EXPAND | GTK_FILL, 0, 0 );

				plugin_entry
				= gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH );
				gtk_entry_set_text( GTK_ENTRY( plugin_entry ),
                    				config.ripper.plugin );
				gtk_table_attach( GTK_TABLE( table ),
                  				plugin_entry,
                  				1, 2, 1, 2,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				label = gtk_label_new( " Wav " );
				label2 = gtk_label_new( " Wav " );
				gtk_notebook_append_page_menu( GTK_NOTEBOOK( notebook ),
                               				main_frame, label, label2 );
				gtk_widget_show_all( main_frame );
				return 0;
			}

		case CW_OK :
			{
				strcpy( config.ripper.ripper,
        				gtk_entry_get_text( GTK_ENTRY( ripper_entry ) ) );
				strcpy( config.ripper.plugin,
        				gtk_entry_get_text( GTK_ENTRY( plugin_entry ) ) );
				return 0;
			}
	}
	/* Just to avoid warning */
	return 0;
}

int cw_mp3_handler( int ops, _main_data *main_data, GtkWidget *notebook )
{
	static GtkWidget * main_frame;
	static GtkWidget *encoder_entry, *plugin_entry;

	switch ( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * vbox, *frame, *label, *label2, *table;

				main_frame = gtk_frame_new( "Mp3 Configuration" );
				gtk_container_border_width( GTK_CONTAINER( main_frame ), 10 );

				vbox = gtk_vbox_new( FALSE, 0 );
				gtk_container_border_width( GTK_CONTAINER( vbox ), 5 );
				gtk_container_add( GTK_CONTAINER( main_frame ), vbox );

				/* Frame for commands */
				frame = gtk_frame_new( "Commands" );
				gtk_container_border_width( GTK_CONTAINER( frame ), 2 );
				gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );

				table = gtk_table_new( 2, 2, FALSE );
				gtk_container_border_width( GTK_CONTAINER( table ), 3 );
				gtk_container_add( GTK_CONTAINER( frame ), table );

				// for encoder
				label = gtk_label_new( "Encoder: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
                  				0, GTK_EXPAND | GTK_FILL, 0, 0 );

				encoder_entry
				= gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH );
				gtk_entry_set_text( GTK_ENTRY( encoder_entry ),
                    				config.encoder.encoder );
				gtk_table_attach( GTK_TABLE( table ),
                  				encoder_entry,
                  				1, 2, 0, 1,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				// for plugin
				label = gtk_label_new( "Plugin: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2,
                  				0, GTK_EXPAND | GTK_FILL, 0, 0 );

				plugin_entry
				= gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH );
				gtk_entry_set_text( GTK_ENTRY( plugin_entry ),
                    				config.encoder.plugin );
				gtk_table_attach( GTK_TABLE( table ),
                  				plugin_entry,
                  				1, 2, 1, 2,
                  				GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0 );

				label = gtk_label_new( " Mp3 " );
				label2 = gtk_label_new( " Mp3 " );
				gtk_notebook_append_page_menu( GTK_NOTEBOOK( notebook ),
                               				main_frame, label, label2 );
				gtk_widget_show_all( main_frame );
				return 0;
			}

		case CW_OK :
			{
				strcpy( config.encoder.encoder,
        				gtk_entry_get_text( GTK_ENTRY( encoder_entry ) ) );
				strcpy( config.encoder.plugin,
        				gtk_entry_get_text( GTK_ENTRY( plugin_entry ) ) );
				return 0;
			}
	}
	/* Just to avoid warning */
	return 0;
}

int cw_players_handler( int ops, _main_data *main_data, GtkWidget *notebook )
{
	static GtkWidget * main_frame;
	static GtkWidget *cd_play_entry, *cd_stop_entry;
	static GtkWidget *wav_entry, *mp3_entry;

	switch ( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * table, *label, *label2;

				main_frame = gtk_frame_new( "Players" );
				gtk_container_border_width( GTK_CONTAINER( main_frame ), 10 );

				table = gtk_table_new( 4, 2, FALSE );
				gtk_table_set_row_spacings( GTK_TABLE( table ), 5 );
				gtk_container_border_width( GTK_CONTAINER( table ), 3 );
				gtk_container_add( GTK_CONTAINER( main_frame ), table );

				label = gtk_label_new( "CD play command: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
                  				0, 0, 0, 0 );
				cd_play_entry = gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH - 2 );
				gtk_entry_set_text( GTK_ENTRY( cd_play_entry ),
                    				config.cd_player.play_command );
				gtk_table_attach( GTK_TABLE( table ), cd_play_entry, 1, 2, 0, 1,
                  				GTK_EXPAND | GTK_FILL, 0, 0, 0 );

				label = gtk_label_new( "CD stop command: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2,
                  				0, 0, 0, 0 );
				cd_stop_entry = gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH - 2 );
				gtk_entry_set_text( GTK_ENTRY( cd_stop_entry ),
                    				config.cd_player.stop_command );
				gtk_table_attach( GTK_TABLE( table ), cd_stop_entry, 1, 2, 1, 2,
                  				GTK_EXPAND | GTK_FILL, 0, 0, 0 );

				label = gtk_label_new( "Wav play command: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3,
                  				0, 0, 0, 0 );
				wav_entry = gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH - 2 );
				gtk_entry_set_text( GTK_ENTRY( wav_entry ),
                    				config.wav_player.command );
				gtk_table_attach( GTK_TABLE( table ), wav_entry, 1, 2, 2, 3,
                  				GTK_EXPAND | GTK_FILL, 0, 0, 0 );

				label = gtk_label_new( "Mp3 play command: " );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4,
                  				0, 0, 0, 0 );
				mp3_entry = gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH - 2 );
				gtk_entry_set_text( GTK_ENTRY( mp3_entry ),
                    				config.mp3_player.command );
				gtk_table_attach( GTK_TABLE( table ), mp3_entry, 1, 2, 3, 4,
                  				GTK_EXPAND | GTK_FILL, 0, 0, 0 );

				label = gtk_label_new( "Players" );
				label2 = gtk_label_new( "Players" );
				gtk_notebook_append_page_menu( GTK_NOTEBOOK( notebook ),
                               				main_frame, label, label2 );
				gtk_widget_show_all( main_frame );
				return 0;
			}

		case CW_OK :
			if ( strlen( gtk_entry_get_text(
           				GTK_ENTRY( cd_play_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text(
                 				GTK_ENTRY( cd_stop_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text(
                 				GTK_ENTRY( wav_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text(
                 				GTK_ENTRY( mp3_entry ) ) ) == 0 )
			{
				err_handler( EMPTY_ENTRY_ERR, "You need to fill every entry in players page" );
				return - 1;
			}
			strcpy( config.cd_player.play_command,
        			gtk_entry_get_text( GTK_ENTRY( cd_play_entry ) ) );
			strcpy( config.cd_player.stop_command,
        			gtk_entry_get_text( GTK_ENTRY( cd_stop_entry ) ) );
			strcpy( config.wav_player.command,
        			gtk_entry_get_text( GTK_ENTRY( wav_entry ) ) );
			strcpy( config.mp3_player.command,
        			gtk_entry_get_text( GTK_ENTRY( mp3_entry ) ) );
			return 0;
	}
	/* Just to avoid warning */
	return - 1;
}

int cw_cddb_handler( int ops, _main_data *main_data, GtkWidget *notebook )
{
	static GtkWidget * main_frame;
	static GtkWidget *cddb_server_entry, *cddb_port_entry;
	static GtkWidget *convert_spaces_ckbx, *include_dtitle_ckbx, *include_tracknum_ckbx,  *include_artist_ckbx, *make_directories_ckbx;
	static GtkWidget *table, *vbox;
	char* cddb_port_num;

	switch ( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * label, *label2;

				main_frame = gtk_frame_new( "CDDB" );
				gtk_container_border_width( GTK_CONTAINER( main_frame ), 10 );

				vbox = gtk_vbox_new( FALSE, 0 );
				gtk_container_border_width( GTK_CONTAINER( vbox ), 5 );

				table = gtk_table_new( 2, 2, FALSE );
				gtk_table_set_row_spacings( GTK_TABLE( table ), 5 );
				gtk_container_border_width( GTK_CONTAINER( table ), 3 );
				gtk_box_pack_start( GTK_BOX( vbox ), table, TRUE, TRUE, 0 );

				label = gtk_label_new( "CDDB server: " );
				cddb_server_entry = gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH - 2 );
				gtk_entry_set_text( GTK_ENTRY( cddb_server_entry ),
                    				config.cddb_config.server );
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
                  				0, 0, 0, 0 );
				gtk_table_attach( GTK_TABLE( table ), cddb_server_entry, 1, 2, 0, 1,
                  				0, 0, 0, 0 );

				label = gtk_label_new( "CDDB port " );
				cddb_port_entry = gtk_entry_new_with_max_length( MAX_COMMAND_LENGTH - 2 );
				cddb_port_num = int2str( config.cddb_config.port );
				gtk_entry_set_text( GTK_ENTRY( cddb_port_entry ), cddb_port_num );
				free( cddb_port_num );
				cddb_port_num = 0;
				gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2,
                  				0, 0, 0, 0 );
				gtk_table_attach( GTK_TABLE( table ), cddb_port_entry, 1, 2, 1, 2,
                  				0, 0, 0, 0 );

				convert_spaces_ckbx = gtk_check_button_new_with_label( "Convert spaces to underscores" );
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( convert_spaces_ckbx ),
                             				config.cddb_config.convert_spaces );
				gtk_container_add( GTK_CONTAINER( vbox ), convert_spaces_ckbx );

				include_artist_ckbx = gtk_check_button_new_with_label( "Include artist in file name" );
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( include_artist_ckbx ),
                             				config.cddb_config.include_artist );
				gtk_container_add( GTK_CONTAINER( vbox ), include_artist_ckbx );

				include_dtitle_ckbx = gtk_check_button_new_with_label("Include disc title in file name");
				gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(include_dtitle_ckbx),
					config.cddb_config.include_dtitle);
				gtk_container_add(GTK_CONTAINER(vbox), include_dtitle_ckbx);

				include_tracknum_ckbx = gtk_check_button_new_with_label("Include track number in file name");
				gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(include_tracknum_ckbx),
					config.cddb_config.include_tracknum);
				gtk_container_add(GTK_CONTAINER(vbox), include_tracknum_ckbx);

				make_directories_ckbx = gtk_check_button_new_with_label("Create album subdirectory for each CD");
				gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(make_directories_ckbx),
					config.cddb_config.make_directories);
				gtk_container_add(GTK_CONTAINER(vbox), make_directories_ckbx);

				gtk_container_add( GTK_CONTAINER( main_frame ), vbox );

				label = gtk_label_new( "CDDB" );
				label2 = gtk_label_new( "CDDB" );
				gtk_notebook_append_page_menu( GTK_NOTEBOOK( notebook ),
                               				main_frame, label, label2 );
				gtk_widget_show_all( main_frame );
				return 0;
			}

		case CW_OK :
			if ( strlen( gtk_entry_get_text( GTK_ENTRY( cddb_server_entry ) ) ) == 0
    				|| strlen( gtk_entry_get_text( GTK_ENTRY( cddb_port_entry ) ) ) == 0 )
			{
				err_handler( EMPTY_ENTRY_ERR, "You need to specify a server and a port" );
				return - 1;
			}
			strcpy( config.cddb_config.server,
        			gtk_entry_get_text( GTK_ENTRY( cddb_server_entry ) ) );

			config.cddb_config.port = atoi( gtk_entry_get_text( GTK_ENTRY( cddb_port_entry ) ) );

			if ( GTK_TOGGLE_BUTTON( convert_spaces_ckbx )->active )
				config.cddb_config.convert_spaces = 1;
			else
				config.cddb_config.convert_spaces = 0;

			if ( GTK_TOGGLE_BUTTON( include_artist_ckbx )->active )
				config.cddb_config.include_artist = 1;
			else
				config.cddb_config.include_artist = 0;

			if (GTK_TOGGLE_BUTTON(include_dtitle_ckbx)->active)
				config.cddb_config.include_dtitle = 1;
			else
				config.cddb_config.include_dtitle = 0;
			
			if (GTK_TOGGLE_BUTTON(include_tracknum_ckbx)->active)
				config.cddb_config.include_tracknum = 1;
			else
				config.cddb_config.include_tracknum = 0;
	
			if (GTK_TOGGLE_BUTTON(make_directories_ckbx)->active)
				config.cddb_config.make_directories = 1;
			else
				config.cddb_config.make_directories = 0;

			return 0;
	}
	/* Just to avoid warning */
	return - 1;
}

void cw_ok_button_clicked( GtkWidget *widget, gpointer callback_data )
{
	config_window_handler( CW_OK, NULL );
}

void cw_cancel_button_clicked( GtkWidget *widget, gpointer callback_data )
{
	config_window_handler( CW_CANCEL, NULL );
}

void config_window_handler( int ops, _main_data *main_data )
{
	static GtkWidget * window = NULL;
	static _main_data *saved_main_data;

	switch( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * vbox, *bbox, *notebook, *separator, *button;

				saved_main_data = main_data;
				window = gtk_window_new( GTK_WINDOW_DIALOG );

				gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                    				GTK_SIGNAL_FUNC( cw_cancel_button_clicked ),
                    				NULL );

				gtk_window_set_title( GTK_WINDOW( window ), "Configuration" );
				gtk_container_border_width( GTK_CONTAINER( window ), 0 );

				vbox = gtk_vbox_new( FALSE, 0 );
				gtk_container_add( GTK_CONTAINER( window ), vbox );

				notebook = gtk_notebook_new();
				gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
				gtk_box_pack_start( GTK_BOX( vbox ), notebook, TRUE, TRUE, 0 );
				gtk_container_border_width( GTK_CONTAINER( notebook ), 10 );

				gtk_widget_realize( window );

				cw_general_handler( WIDGET_CREATE, main_data, notebook );
				cw_wav_handler( WIDGET_CREATE, main_data, notebook );
				cw_mp3_handler( WIDGET_CREATE, main_data, notebook );
				cw_players_handler( WIDGET_CREATE, main_data, notebook );
				cw_cddb_handler( WIDGET_CREATE, main_data, notebook );

				separator = gtk_hseparator_new();
				gtk_box_pack_start( GTK_BOX( vbox ), separator, FALSE, TRUE, 10 );

				bbox = gtk_hbox_new( TRUE, 5 );
				gtk_container_border_width( GTK_CONTAINER( bbox ), 10 );
				gtk_box_pack_start( GTK_BOX( vbox ), bbox, FALSE, TRUE, 0 );

				button = gtk_button_new_with_label( "Cancel" );
				gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                    				GTK_SIGNAL_FUNC( cw_cancel_button_clicked ),
                    				NULL );
				gtk_box_pack_end( GTK_BOX( bbox ), button, TRUE, TRUE, 0 );
				GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );

				button = gtk_button_new_with_label( "OK" );
				gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                    				GTK_SIGNAL_FUNC( cw_ok_button_clicked ),
                    				NULL );

				gtk_box_pack_end( GTK_BOX( bbox ), button, TRUE, TRUE, 0 );
				GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
				gtk_widget_grab_default( button );

				gtk_widget_show_all( window );
				return;
			}

		case CW_OK :
			main_data = saved_main_data;
			if ( cw_general_handler( CW_OK, main_data, NULL ) < 0
    				|| cw_wav_handler( CW_OK, main_data, NULL ) < 0
    				|| cw_mp3_handler( CW_OK, main_data, NULL ) < 0
    				|| cw_players_handler( CW_OK, main_data, NULL ) < 0
    				|| cw_cddb_handler( CW_OK, main_data, NULL ) < 0 )
			{
				return;
			}

			gtk_widget_destroy( window );
			main_window_handler( MW_MODE_SELECT, 0, main_data );
			/*{
			  printf("==Debug Info==\n");
			  printf("wav path : <%s>,   mp3 path : <%s>\n", 
			         config.wav_path, config.mp3_path);
			  printf("wav format : <%s>,   mp3 format : <%s>\n",
			         config.wav_file_name_format, config.mp3_file_name_format);
			  printf("prepend char : %c,   make mp3 from existing wav : %d\n",
			         config.prepend_char, config.make_mp3_from_existing_wav);
			  printf("--ripper     --\n");
			  printf("file : <%s>\nplugin : <%s>\n",
			         config.ripper.ripper, config.ripper.plugin);
			  printf("--encoder    --\n");
			  printf("file : <%s>\nplugin : <%s>\n",
			         config.encoder.encoder, config.encoder.plugin);
			  printf("--Cd player  --\n");
			  printf("Play : <%s>,   Stop : <%s>\n",
			  config.cd_player.play_command, config.cd_player.stop_command);
			  printf("--Wav Player --\n");
			  printf("Command : <%s>\n",
			         config.wav_player.command);
			  printf("--Mp3 Player --\n");
			  printf("Command : <%s>\n",
			         config.mp3_player.command);
			  }*/
			return;

		case CW_CANCEL :
			gtk_widget_destroy( window );
			main_window_handler( MW_MODE_SELECT, 0, main_data );
			return;
	}
}
 
